/*
 * 使用本软件请从杭州钛特云有限公司获取授权，其它途径获取本软件的行为皆为侵权行为
 * 本源代码由杭州钛特云科技有限公司授权给江苏南大先腾信息产业股份有限公司使用
 */
/**
 * Copyright (c) 2011-2019, James Zhan 詹波 (jfinal@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.tio.jfinal.template.stat.ast;

import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.Scope;

import java.io.IOException;

/**
 * Stat
 */
public abstract class Stat {

	protected Location location;

	public Stat setLocation(Location location) {
		this.location = location;
		return this;
	}

	public Location getLocation() {
		return location;
	}

	public void setExprList(ExprList exprList) {
	}

	public void setStat(Stat stat) {
	}

	public abstract void exec(Env env, Scope scope, Writer writer);

	public boolean hasEnd() {
		return false;
	}

	protected void write(Writer writer, String str) {
		try {
			writer.write(str, 0, str.length());
		} catch (IOException e) {
			throw new TemplateException(e.getMessage(), location, e);
		}
	}
}


