/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.tio.jfinal.plugin.activerecord.ActiveRecordException;
import org.tio.jfinal.plugin.activerecord.Config;
import org.tio.jfinal.plugin.activerecord.DbKit;
import org.tio.jfinal.plugin.activerecord.JavaType;
import org.tio.jfinal.plugin.activerecord.NullDataSource;
import org.tio.jfinal.plugin.activerecord.Table;
import org.tio.jfinal.plugin.activerecord.TableMapping;

public class TableBuilder {
    protected JavaType javaType = new JavaType();

    public void build(List<Table> tableList, Config config) {
        if (config.dataSource instanceof NullDataSource) {
            return;
        }
        Table temp = null;
        Connection conn = null;
        try {
            conn = config.dataSource.getConnection();
            TableMapping tableMapping = TableMapping.me();
            Iterator<Table> iterator = tableList.iterator();
            while (iterator.hasNext()) {
                Table table;
                temp = table = iterator.next();
                this.doBuild(table, conn, config);
                tableMapping.putTable(table);
                DbKit.addModelToConfigMapping(table.getModelClass(), config);
            }
        }
        catch (Exception e) {
            if (temp != null) {
                System.err.println("Can not create Table object, maybe the table " + temp.getName() + " is not exists.");
            }
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    protected void doBuild(Table table, Connection conn, Config config) throws SQLException {
        table.setColumnTypeMap(config.containerFactory.getAttrsMap());
        if (table.getPrimaryKey() == null) {
            table.setPrimaryKey(config.dialect.getDefaultPrimaryKey());
        }
        String sql = config.dialect.forTableBuilderDoBuild(table.getName());
        Statement stm = conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i);
            String colClassName = rsmd.getColumnClassName(i);
            Class<?> clazz = this.javaType.getType(colClassName);
            if (clazz != null) {
                table.setColumnType(colName, clazz);
                continue;
            }
            int type = rsmd.getColumnType(i);
            if (type == -2 || type == -3 || type == 2004) {
                table.setColumnType(colName, byte[].class);
                continue;
            }
            if (type == 2005 || type == 2011) {
                table.setColumnType(colName, String.class);
                continue;
            }
            if (type == 93) {
                table.setColumnType(colName, Timestamp.class);
                continue;
            }
            if (type == 91) {
                table.setColumnType(colName, Date.class);
                continue;
            }
            if (type == 1111) {
                table.setColumnType(colName, Object.class);
                continue;
            }
            table.setColumnType(colName, String.class);
        }
        rs.close();
        stm.close();
    }
}

