/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.dialect;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tio.jfinal.plugin.activerecord.Model;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.Table;
import org.tio.jfinal.plugin.activerecord.builder.TimestampProcessedModelBuilder;
import org.tio.jfinal.plugin.activerecord.builder.TimestampProcessedRecordBuilder;
import org.tio.jfinal.plugin.activerecord.dialect.Dialect;

public class PostgreSqlDialect
extends Dialect {
    public PostgreSqlDialect() {
        this.modelBuilder = TimestampProcessedModelBuilder.me;
        this.recordBuilder = TimestampProcessedRecordBuilder.me;
    }

    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from \"" + tableName + "\" where 1 = 2";
    }

    @Override
    public String forFindAll(String tableName) {
        return "select * from \"" + tableName + "\"";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into \"").append(table.getName()).append("\"(");
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append('\"').append(colName).append('\"');
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public String forModelDeleteById(Table table) {
        String[] pKeys = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from \"");
        sql.append(table.getName());
        sql.append("\" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
        }
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, StringBuilder sql, List<Object> paras) {
        sql.append("update \"").append(table.getName()).append("\" set ");
        String[] pKeys = table.getPrimaryKey();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append('\"').append(colName).append("\" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
            paras.add(attrs.get(pKeys[i]));
        }
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        int i;
        StringBuilder sql = new StringBuilder("select ");
        if ("*".equals(columns = columns.trim())) {
            sql.append('*');
        } else {
            String[] arr = columns.split(",");
            for (i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sql.append(',');
                }
                sql.append('\"').append(arr[i].trim()).append('\"');
            }
        }
        sql.append(" from \"");
        sql.append(table.getName());
        sql.append("\" where ");
        String[] pKeys = table.getPrimaryKey();
        for (i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbFindById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("select * from \"").append(tableName).append("\" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("delete from \"").append(tableName).append("\" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
        }
        return sql.toString();
    }

    @Override
    public void forDbSave(String tableName, String[] pKeys, Record record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        sql.append("insert into \"");
        sql.append(tableName).append("\"(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append('\"').append(e.getKey()).append('\"');
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Record record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        sql.append("update \"").append(tableName).append("\" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (this.isPrimaryKey(colName, pKeys)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append('\"').append(colName).append("\" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('\"').append(pKeys[i]).append("\" = ?");
            paras.add(ids[i]);
        }
    }

    @Override
    public String forPaginate(int pageNumber, int pageSize, StringBuilder findSql) {
        int offset = pageSize * (pageNumber - 1);
        findSql.append(" limit ").append(pageSize).append(" offset ").append(offset);
        return findSql.toString();
    }

    @Override
    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        this.fillStatementHandleDateType(pst, paras);
    }

    @Override
    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        this.fillStatementHandleDateType(pst, paras);
    }

    @Override
    public void getModelGeneratedKey(Model<?> model, PreparedStatement pst, Table table) throws SQLException {
        String[] pKeys = table.getPrimaryKey();
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            Class<?> colType;
            if (model.get(pKey) != null && !this.isOracle() || !rs.next() || (colType = table.getColumnType(pKey)) == null) continue;
            if (colType == Integer.class || colType == Integer.TYPE) {
                model.set(pKey, rs.getInt(pKey));
                continue;
            }
            if (colType == Long.class || colType == Long.TYPE) {
                model.set(pKey, rs.getLong(pKey));
                continue;
            }
            if (colType == BigInteger.class) {
                this.processGeneratedBigIntegerKey(model, pKey, rs.getObject(pKey));
                continue;
            }
            model.set(pKey, rs.getObject(pKey));
        }
        rs.close();
    }

    @Override
    public void getRecordGeneratedKey(PreparedStatement pst, Record record, String[] pKeys) throws SQLException {
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            if (record.get(pKey) != null && !this.isOracle() || !rs.next()) continue;
            record.set(pKey, rs.getObject(pKey));
        }
        rs.close();
    }
}

