/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.generator;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.StrKit;
import org.tio.jfinal.plugin.activerecord.generator.TableMeta;
import org.tio.jfinal.template.Engine;

public class ModelGenerator {
    protected Engine engine;
    protected String template = "/org/tio/jfinal/plugin/activerecord/generator/model_template.jf";
    protected String modelPackageName;
    protected String baseModelPackageName;
    protected String modelOutputDir;
    protected boolean generateDaoInModel = false;

    public ModelGenerator(String modelPackageName, String baseModelPackageName, String modelOutputDir) {
        if (StrKit.isBlank(modelPackageName)) {
            throw new IllegalArgumentException("modelPackageName can not be blank.");
        }
        if (modelPackageName.contains("/") || modelPackageName.contains("\\")) {
            throw new IllegalArgumentException("modelPackageName error : " + modelPackageName);
        }
        if (StrKit.isBlank(baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank(modelOutputDir)) {
            throw new IllegalArgumentException("modelOutputDir can not be blank.");
        }
        this.modelPackageName = modelPackageName;
        this.baseModelPackageName = baseModelPackageName;
        this.modelOutputDir = modelOutputDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod(new StrKit());
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        this.generateDaoInModel = generateDaoInModel;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate model ...");
        System.out.println("Model Output Dir: " + this.modelOutputDir);
        for (TableMeta tableMeta : tableMetas) {
            this.genModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genModelContent(TableMeta tableMeta) {
        String ret;
        Kv data = Kv.by("modelPackageName", this.modelPackageName);
        data.set("baseModelPackageName", this.baseModelPackageName);
        data.set("generateDaoInModel", this.generateDaoInModel);
        data.set("tableMeta", tableMeta);
        tableMeta.modelContent = ret = this.engine.getTemplate(this.template).renderToString(data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToFile(TableMeta tableMeta) throws IOException {
        String target;
        File file;
        File dir = new File(this.modelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(target = this.modelOutputDir + File.separator + tableMeta.modelName + ".java")).exists()) {
            return;
        }
        try (OutputStreamWriter osw = null;){
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            osw.write(tableMeta.modelContent);
        }
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public String getBaseModelPackageName() {
        return this.baseModelPackageName;
    }

    public String getModelOutputDir() {
        return this.modelOutputDir;
    }
}

