/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.sql;

import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Const;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class NameSpaceDirective
extends Directive {
    static final String NAME_SPACE_KEY = "_NAME_SPACE_";
    private String nameSpace;

    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #namespace directive can not be blank", this.location);
        }
        if (exprList.length() > 1) {
            throw new ParseException("Only one parameter allowed for #namespace directive", this.location);
        }
        Expr expr = exprList.getExpr(0);
        if (!(expr instanceof Const) || !((Const)expr).isStr()) {
            throw new ParseException("The parameter of #namespace directive must be String", this.location);
        }
        this.nameSpace = ((Const)expr).getStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (scope.get(NAME_SPACE_KEY) != null) {
            throw new TemplateException("#namespace directive can not be nested", this.location);
        }
        scope.set(NAME_SPACE_KEY, this.nameSpace);
        try {
            this.stat.exec(env, scope, writer);
        }
        finally {
            scope.remove(NAME_SPACE_KEY);
        }
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

