/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.sql;

import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Const;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.expr.ast.Id;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class ParaDirective
extends Directive {
    private int index = -1;
    private String paraName = null;
    private static boolean checkParaAssigned = true;

    public static void setCheckParaAssigned(boolean checkParaAssigned) {
        ParaDirective.checkParaAssigned = checkParaAssigned;
    }

    @Override
    public void setExprList(ExprList exprList) {
        Expr expr;
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #para directive can not be blank", this.location);
        }
        if (exprList.length() == 1 && (expr = exprList.getExpr(0)) instanceof Const && ((Const)expr).isInt()) {
            this.index = ((Const)expr).getInt();
            if (this.index < 0) {
                throw new ParseException("The index of para array must greater than -1", this.location);
            }
        }
        if (checkParaAssigned && exprList.getLastExpr() instanceof Id) {
            Id id = (Id)exprList.getLastExpr();
            this.paraName = id.getId();
        }
        this.exprList = exprList;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        SqlPara sqlPara = (SqlPara)scope.get("_SQL_PARA_");
        if (sqlPara == null) {
            throw new TemplateException("#para directive invoked by getSqlPara(...) method only", this.location);
        }
        this.write(writer, "?");
        if (this.index == -1) {
            if (checkParaAssigned && this.paraName != null && !scope.exists(this.paraName)) {
                throw new TemplateException("The parameter \"" + this.paraName + "\" must be assigned", this.location);
            }
            sqlPara.addPara(this.exprList.eval(scope));
        } else {
            Object[] paras = (Object[])scope.get("_PARA_ARRAY_");
            if (paras == null) {
                throw new TemplateException("The #para(" + this.index + ") directive must invoked by getSqlPara(String, Object...) method", this.location);
            }
            if (this.index >= paras.length) {
                throw new TemplateException("The index of #para directive is out of bounds: " + this.index, this.location);
            }
            sqlPara.addPara(paras[this.index]);
        }
    }
}

