/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.sql;

import java.util.Map;
import org.tio.jfinal.kit.StrKit;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.Template;
import org.tio.jfinal.template.expr.ast.Const;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class SqlDirective
extends Directive {
    private String id;

    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #sql directive can not be blank", this.location);
        }
        if (exprList.length() > 1) {
            throw new ParseException("Only one parameter allowed for #sql directive", this.location);
        }
        Expr expr = exprList.getExpr(0);
        if (!(expr instanceof Const) || !((Const)expr).isStr()) {
            throw new ParseException("The parameter of #sql directive must be String", this.location);
        }
        this.id = ((Const)expr).getStr();
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String nameSpace = (String)scope.get("_NAME_SPACE_");
        String key = StrKit.isBlank(nameSpace) ? this.id : nameSpace + "." + this.id;
        Map sqlTemplateMap = (Map)scope.get("_SQL_TEMPLATE_MAP_");
        if (sqlTemplateMap.containsKey(key)) {
            throw new ParseException("Sql already exists with key : " + key, this.location);
        }
        sqlTemplateMap.put(key, new Template(env, this.stat));
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

