/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.activerecord.sql.proxy;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.StrKit;
import org.tio.jfinal.plugin.activerecord.sql.proxy.ProxyPreparedStatement;

public class SqlLog {
    public static final Logger slowsqlLog = LoggerFactory.getLogger((String)"slowsqlLog");
    public static final Logger querysqlLog = LoggerFactory.getLogger((String)"querysqlLog");
    public static final Logger updatesqlLog = LoggerFactory.getLogger((String)"updatesqlLog");
    public static final Logger errorsqlLog = LoggerFactory.getLogger((String)"errorsqlLog");
    static final String NULL = "null";
    static final long SLOWSQL_COST = 1000L;

    public static void logUpdate(String sql, ProxyPreparedStatement pps, long cost, Throwable e) {
        SqlLog.log(sql, pps, cost, e, updatesqlLog);
    }

    public static void logQuery(String sql, ProxyPreparedStatement pps, long cost, Throwable e) {
        SqlLog.log(sql, pps, cost, e, querysqlLog);
    }

    private static void log(String sql, ProxyPreparedStatement pps, long cost, Throwable e, Logger log) {
        if (StrKit.isBlank(sql)) {
            sql = pps.sql;
        }
        Map<Integer, Object> params = pps.params;
        String realSql = SqlLog.realSql(sql, params);
        String logStr = cost + "ms\r\n" + realSql;
        log.info(logStr);
        SqlLog.logSlowAndError(logStr, cost, e);
    }

    public static void logBatch(ProxyPreparedStatement pps, long cost, Throwable e) {
        List<String> sqlList = pps.sqlList;
        StringBuilder sb = null;
        if (sqlList != null && sqlList.size() > 0) {
            sb = new StringBuilder(sqlList.size() * sqlList.get(0).length());
            sb.append("batch sql_list:").append(sqlList.size()).append(", ").append(cost).append("ms\r\n");
            for (String sql : sqlList) {
                sb.append(sql).append(";\r\n");
            }
        } else {
            List<Map<Integer, Object>> paramsList = pps.paramsList;
            if (paramsList != null && paramsList.size() > 0) {
                sb = new StringBuilder(paramsList.size() * (pps.sql.length() + 20));
                sb.append("batch params_list:").append(paramsList.size()).append(", ").append(cost).append("ms\r\n");
                for (Map<Integer, Object> params : paramsList) {
                    String realSql = SqlLog.realSql(pps.sql, params);
                    sb.append(realSql).append(";\r\n");
                }
            }
        }
        String logStr = sb.toString();
        updatesqlLog.info(logStr);
        SqlLog.logSlowAndError(logStr, cost, e);
    }

    private static void logSlowAndError(String logStr, long cost, Throwable e) {
        if (cost >= 1000L) {
            slowsqlLog.info(logStr);
        }
        if (e != null) {
            errorsqlLog.error(logStr, e);
        }
    }

    public static String realSql(String sql, Map<Integer, Object> params) {
        if (params == null || params.size() == 0) {
            return sql;
        }
        int len = sql.length();
        StringBuilder sb = new StringBuilder(len + params.size() * 10);
        int indexOfParams = 1;
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if (c == '?') {
                Object obj;
                if ((obj = params.get(indexOfParams++)) == null) {
                    sb.append(NULL);
                    continue;
                }
                if (obj instanceof String) {
                    sb.append("'").append(obj).append("'");
                    continue;
                }
                if (obj instanceof Date) {
                    SimpleDateFormat aDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sb.append("'").append(aDate.format((Date)obj)).append("'");
                    continue;
                }
                sb.append(obj);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private SqlLog() {
    }
}

