/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.plugin.ehcache;

import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.tio.jfinal.plugin.ehcache.IDataLoader;

public class CacheKit {
    private static CacheManager cacheManager;

    static void init(CacheManager cacheManager) {
        CacheKit.cacheManager = cacheManager;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Cache getOrAddCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) return cache;
        Class<CacheKit> clazz = CacheKit.class;
        synchronized (CacheKit.class) {
            cache = cacheManager.getCache(cacheName);
            if (cache != null) return cache;
            System.out.println("Could not find cache config [" + cacheName + "], using default.");
            cacheManager.addCacheIfAbsent(cacheName);
            cache = cacheManager.getCache(cacheName);
            System.out.println("Cache [" + cacheName + "] started.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    public static void put(String cacheName, Object key, Object value) {
        CacheKit.getOrAddCache(cacheName).put(new Element(key, value));
    }

    public static <T> T get(String cacheName, Object key) {
        Element element = CacheKit.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static List getKeys(String cacheName) {
        return CacheKit.getOrAddCache(cacheName).getKeys();
    }

    public static void remove(String cacheName, Object key) {
        CacheKit.getOrAddCache(cacheName).remove(key);
    }

    public static void removeAll(String cacheName) {
        CacheKit.getOrAddCache(cacheName).removeAll();
    }

    public static <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = CacheKit.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            CacheKit.put(cacheName, key, data);
        }
        return data;
    }

    public static <T> T get(String cacheName, Object key, Class<? extends IDataLoader> dataLoaderClass) {
        Object data = CacheKit.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader dataLoader = dataLoaderClass.newInstance();
                data = dataLoader.load();
                CacheKit.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }
}

