/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.tio.jfinal.kit.StrKit;
import org.tio.jfinal.proxy.ProxyClassLoader;
import org.tio.jfinal.template.expr.ast.FieldGetter;
import org.tio.jfinal.template.expr.ast.MethodKit;

public class FastFieldGetter
extends FieldGetter {
    protected static ProxyGenerator generator = new ProxyGenerator();
    protected static ProxyCompiler compiler = new ProxyCompiler();
    protected static ProxyClassLoader classLoader = new ProxyClassLoader();
    protected static Map<Class<?>, Proxy> cache = new ConcurrentHashMap(512, 0.25f);
    protected static boolean outputCompileError = false;
    protected Proxy proxy;
    protected Method getterMethod;

    public FastFieldGetter(Proxy proxy, Method getterMethod) {
        this.proxy = proxy;
        this.getterMethod = getterMethod;
    }

    public FastFieldGetter() {
        this(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGetter takeOver(Class<?> targetClass, String fieldName) {
        Method[] methodArray;
        if (MethodKit.isForbiddenClass(targetClass)) {
            throw new RuntimeException("Forbidden class: " + targetClass.getName());
        }
        String getterName = "get" + StrKit.firstCharToUpperCase(fieldName);
        for (Method method : methodArray = targetClass.getMethods()) {
            if (!method.getName().equals(getterName) || method.getParameterCount() != 0) continue;
            Proxy proxy = cache.get(targetClass);
            if (proxy == null) {
                Class<?> clazz = targetClass;
                synchronized (clazz) {
                    proxy = cache.get(targetClass);
                    if (proxy == null) {
                        try {
                            proxy = this.createProxy(targetClass, fieldName);
                        }
                        catch (Throwable e) {
                            return null;
                        }
                        cache.putIfAbsent(targetClass, proxy);
                    }
                }
            }
            return new FastFieldGetter(proxy, method);
        }
        return null;
    }

    @Override
    public Object get(Object target, String fieldName) throws Exception {
        return this.proxy.getValue(target, fieldName);
    }

    protected Proxy createProxy(Class<?> targetClass, String fieldName) {
        ProxyClass proxyClass = new ProxyClass(targetClass);
        String sourceCode = generator.generate(proxyClass);
        proxyClass.setSourceCode(sourceCode);
        compiler.compile(proxyClass);
        Class<?> retClass = classLoader.loadProxyClass(proxyClass);
        proxyClass.setClazz(retClass);
        try {
            return (Proxy)retClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getterMethod.toString();
    }

    public static void setOutputCompileError(boolean outputCompileError) {
        FastFieldGetter.outputCompileError = outputCompileError;
    }

    static class ProxyCompiler
    extends org.tio.jfinal.proxy.ProxyCompiler {
        ProxyCompiler() {
        }

        @Override
        protected void outputCompileError(Boolean result, DiagnosticCollector<JavaFileObject> collector) {
            if (outputCompileError) {
                super.outputCompileError(result, collector);
            }
        }
    }

    static class ProxyGenerator {
        ProxyGenerator() {
        }

        String generate(ProxyClass proxyClass) {
            Method[] methodArray;
            StringBuilder ret = new StringBuilder(1024);
            Class<?> targetClass = proxyClass.getTarget();
            String className = proxyClass.getName();
            ret.append("package ").append(proxyClass.getPkg()).append(";\n\n");
            ret.append("import org.tio.jfinal.template.expr.ast.FastFieldGetter.Proxy;\n\n");
            ret.append("public class ").append(className).append(" implements Proxy {\n\n");
            ret.append("\tpublic Object getValue(Object target, String fieldName) {\n");
            ret.append("\t\tint hash = fieldName.hashCode();\n");
            ret.append("\t\tswitch (hash) {\n");
            for (Method method : methodArray = targetClass.getMethods()) {
                String mn = method.getName();
                if (method.getParameterCount() != 0 || !mn.startsWith("get") || mn.equals("getClass")) continue;
                String fieldName = StrKit.firstCharToLowerCase(mn.substring(3));
                ret.append("\t\tcase ").append(fieldName.hashCode()).append(" :\n");
                ret.append("\t\t\treturn ((").append(targetClass.getName()).append(")target).").append(mn).append("();\n");
            }
            ret.append("\t\tdefault :\n");
            ret.append("\t\t\tthrow new RuntimeException(\"Can not access the field \\\"\" + target.getClass().getName() + \".\" + fieldName + \"\\\"\");\n");
            ret.append("\t\t}\n");
            ret.append("\t}\n");
            ret.append("}\n");
            return ret.toString();
        }
    }

    static class ProxyClass
    extends org.tio.jfinal.proxy.ProxyClass {
        private String name;

        public ProxyClass(Class<?> target) {
            super(target);
            this.name = target.getSimpleName() + "$$EnhancerByJFinal_FieldGetter";
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static interface Proxy {
        public Object getValue(Object var1, String var2);
    }
}

