/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class Index
extends Expr {
    private Expr expr;
    private Expr index;

    public Index(Expr expr, Expr index, Location location) {
        if (expr == null || index == null) {
            throw new ParseException("array/list/map and their index can not be null", location);
        }
        this.expr = expr;
        this.index = index;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object target = this.expr.eval(scope);
        if (target == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The index access operation target can not be null", this.location);
        }
        Object idx = this.index.eval(scope);
        if (idx == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            if (!(target instanceof Map)) {
                throw new TemplateException("The index of list and array can not be null", this.location);
            }
        }
        if (target instanceof List) {
            if (idx instanceof Integer) {
                return ((List)target).get((Integer)idx);
            }
            throw new TemplateException("The index of list must be integer", this.location);
        }
        if (target instanceof Map) {
            return ((Map)target).get(idx);
        }
        if (target.getClass().isArray()) {
            if (idx instanceof Integer) {
                return Array.get(target, (Integer)idx);
            }
            throw new TemplateException("The index of array must be integer", this.location);
        }
        throw new TemplateException("Only the list array and map is supported by index access", this.location);
    }
}

