/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodInfo {
    protected final Long key;
    protected final Class<?> clazz;
    protected final Method method;
    protected final boolean isVarArgs;
    protected final Class<?>[] paraTypes;

    public MethodInfo(Long key, Class<?> clazz, Method method) {
        this.key = key;
        this.clazz = clazz;
        this.method = method;
        this.isVarArgs = method.isVarArgs();
        this.paraTypes = method.getParameterTypes();
    }

    public Object invoke(Object target, Object ... args) throws ReflectiveOperationException {
        if (this.isVarArgs) {
            return this.invokeVarArgsMethod(target, args);
        }
        return this.method.invoke(target, args);
    }

    protected Object invokeVarArgsMethod(Object target, Object[] argValues) throws ReflectiveOperationException {
        Object[] finalArgValues = new Object[this.paraTypes.length];
        int fixedParaLength = this.paraTypes.length - 1;
        System.arraycopy(argValues, 0, finalArgValues, 0, fixedParaLength);
        Class<?> varParaComponentType = this.paraTypes[this.paraTypes.length - 1].getComponentType();
        Object varParaValues = Array.newInstance(varParaComponentType, argValues.length - fixedParaLength);
        int p = 0;
        for (int i = fixedParaLength; i < argValues.length; ++i) {
            Array.set(varParaValues, p++, argValues[i]);
        }
        finalArgValues[this.paraTypes.length - 1] = varParaValues;
        return this.method.invoke(target, finalArgValues);
    }

    public Long getKey() {
        return this.key;
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    protected Class<?>[] getParameterTypes() {
        return this.paraTypes;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.clazz.getName()).append(".").append(this.method.getName()).append("(");
        for (int i = 0; i < this.paraTypes.length; ++i) {
            if (i > 0) {
                ret.append(", ");
            }
            ret.append(this.paraTypes[i].getName());
        }
        return ret.append(")").toString();
    }

    protected MethodInfo() {
        this.key = null;
        this.clazz = null;
        this.method = null;
        this.isVarArgs = false;
        this.paraTypes = null;
    }

    public boolean notNull() {
        return true;
    }
}

