/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tio.jfinal.kit.ReflectKit;
import org.tio.jfinal.kit.SyncWriteMap;
import org.tio.jfinal.template.expr.ast.MethodInfo;
import org.tio.jfinal.template.expr.ast.MethodInfoExt;
import org.tio.jfinal.template.expr.ast.MethodKeyBuilder;
import org.tio.jfinal.template.expr.ast.NullMethodInfo;
import org.tio.jfinal.template.ext.extensionmethod.ByteExt;
import org.tio.jfinal.template.ext.extensionmethod.DoubleExt;
import org.tio.jfinal.template.ext.extensionmethod.FloatExt;
import org.tio.jfinal.template.ext.extensionmethod.IntegerExt;
import org.tio.jfinal.template.ext.extensionmethod.LongExt;
import org.tio.jfinal.template.ext.extensionmethod.ShortExt;
import org.tio.jfinal.template.ext.extensionmethod.StringExt;

public class MethodKit {
    private static final Class<?>[] NULL_ARG_TYPES = new Class[0];
    private static final Set<String> forbiddenMethods = new HashSet<String>(64);
    private static final Set<Class<?>> forbiddenClasses = new HashSet(64);
    private static final Map<Class<?>, Class<?>> primitiveMap = new HashMap(64);
    private static final SyncWriteMap<Long, MethodInfo> methodCache = new SyncWriteMap(2048, 0.25f);
    private static final Map<Class<?>, Class<?>> primitiveToBoxedMap;

    public static boolean isForbiddenClass(Class<?> clazz) {
        return forbiddenClasses.contains(clazz);
    }

    public static void addForbiddenClass(Class<?> clazz) {
        forbiddenClasses.add(clazz);
    }

    public static void removeForbiddenClass(Class<?> clazz) {
        forbiddenClasses.remove(clazz);
    }

    public static boolean isForbiddenMethod(String methodName) {
        return forbiddenMethods.contains(methodName);
    }

    public static void addForbiddenMethod(String methodName) {
        forbiddenMethods.add(methodName);
    }

    public static void removeForbiddenMethod(String methodName) {
        forbiddenMethods.remove(methodName);
    }

    public static void clearCache() {
        methodCache.clear();
    }

    public static MethodInfo getMethod(Class<?> targetClass, String methodName, Object[] argValues) {
        Class<?>[] argTypes = MethodKit.getArgTypes(argValues);
        Long key = MethodKit.getMethodKey(targetClass, methodName, argTypes);
        MethodInfo method = (MethodInfo)methodCache.get(key);
        if (method == null) {
            method = MethodKit.doGetMethod(key, targetClass, methodName, argTypes);
            methodCache.putIfAbsent(key, method);
        }
        return method;
    }

    static Class<?>[] getArgTypes(Object[] argValues) {
        if (argValues == null || argValues.length == 0) {
            return NULL_ARG_TYPES;
        }
        Class[] argTypes = new Class[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            argTypes[i] = argValues[i] != null ? argValues[i].getClass() : null;
        }
        return argTypes;
    }

    private static MethodInfo doGetMethod(Long key, Class<?> targetClass, String methodName, Class<?>[] argTypes) {
        Method[] methodArray;
        if (forbiddenClasses.contains(targetClass)) {
            throw new RuntimeException("Forbidden class: " + targetClass.getName());
        }
        for (Method method : methodArray = targetClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] paraTypes = method.getParameterTypes();
            if (MethodKit.matchFixedArgTypes(paraTypes, argTypes)) {
                return new MethodInfo(key, targetClass, method);
            }
            if (!method.isVarArgs() || !MethodKit.matchVarArgTypes(paraTypes, argTypes)) continue;
            return new MethodInfo(key, targetClass, method);
        }
        return NullMethodInfo.me;
    }

    static boolean matchFixedArgTypes(Class<?>[] paraTypes, Class<?>[] argTypes) {
        if (paraTypes.length != argTypes.length) {
            return false;
        }
        return MethodKit.matchRangeTypes(paraTypes, argTypes, paraTypes.length);
    }

    private static boolean matchRangeTypes(Class<?>[] paraTypes, Class<?>[] argTypes, int matchLength) {
        for (int i = 0; i < matchLength; ++i) {
            if (argTypes[i] == null) {
                if (!paraTypes[i].isPrimitive()) continue;
                return false;
            }
            if (paraTypes[i].isAssignableFrom(argTypes[i]) || paraTypes[i] == argTypes[i] || primitiveMap.get(paraTypes[i]) == argTypes[i]) continue;
            return false;
        }
        return true;
    }

    static boolean matchVarArgTypes(Class<?>[] paraTypes, Class<?>[] argTypes) {
        int fixedParaLength = paraTypes.length - 1;
        if (argTypes.length < fixedParaLength) {
            return false;
        }
        if (!MethodKit.matchRangeTypes(paraTypes, argTypes, fixedParaLength)) {
            return false;
        }
        Class<?> varArgType = paraTypes[paraTypes.length - 1].getComponentType();
        for (int i = fixedParaLength; i < argTypes.length; ++i) {
            if (argTypes[i] == null) {
                if (!varArgType.isPrimitive()) continue;
                return false;
            }
            if (varArgType.isAssignableFrom(argTypes[i]) || varArgType == argTypes[i] || primitiveMap.get(varArgType) == argTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static Long getMethodKey(Class<?> targetClass, String methodName, Class<?>[] argTypes) {
        return MethodKeyBuilder.instance.getMethodKey(targetClass, methodName, argTypes);
    }

    public static synchronized void addExtensionMethod(Class<?> targetClass, Object objectOfExtensionClass) {
        Method[] methodArray;
        Class<?> extensionClass = objectOfExtensionClass.getClass();
        for (Method method : methodArray = extensionClass.getMethods()) {
            Class<?> decClass = method.getDeclaringClass();
            if (decClass == Object.class) continue;
            Class<?>[] extensionMethodParaTypes = method.getParameterTypes();
            String methodName = method.getName();
            if (extensionMethodParaTypes.length == 0) {
                throw new RuntimeException(MethodKit.buildMethodSignatureForException("Extension method requires at least one argument: " + extensionClass.getName() + ".", methodName, extensionMethodParaTypes));
            }
            if (targetClass != extensionMethodParaTypes[0]) {
                throw new RuntimeException(MethodKit.buildMethodSignatureForException("The first argument type of : " + extensionClass.getName() + ".", methodName, extensionMethodParaTypes) + " must be: " + targetClass.getName());
            }
            Class[] targetParaTypes = new Class[extensionMethodParaTypes.length - 1];
            System.arraycopy(extensionMethodParaTypes, 1, targetParaTypes, 0, targetParaTypes.length);
            try {
                Method error = targetClass.getMethod(methodName, targetParaTypes);
                if (error == null) continue;
                throw new RuntimeException("Extension method \"" + methodName + "\" is already exists in class \"" + targetClass.getName() + "\"");
            }
            catch (NoSuchMethodException e) {
                Long key = MethodKit.getMethodKey(targetClass, methodName, MethodKit.toBoxedType(targetParaTypes));
                if (methodCache.containsKey(key)) {
                    throw new RuntimeException(MethodKit.buildMethodSignatureForException("The extension method is already exists: " + extensionClass.getName() + ".", methodName, targetParaTypes));
                }
                MethodInfoExt mie = new MethodInfoExt(objectOfExtensionClass, key, extensionClass, method);
                methodCache.putIfAbsent(key, mie);
            }
        }
    }

    public static void addExtensionMethod(Class<?> targetClass, Class<?> extensionClass) {
        MethodKit.addExtensionMethod(targetClass, ReflectKit.newInstance(extensionClass));
    }

    public static void removeExtensionMethod(Class<?> targetClass, Object objectOfExtensionClass) {
        Method[] methodArray;
        Class<?> extensionClass = objectOfExtensionClass.getClass();
        for (Method method : methodArray = extensionClass.getMethods()) {
            Class<?> decClass = method.getDeclaringClass();
            if (decClass == Object.class) continue;
            Class<?>[] extensionMethodParaTypes = method.getParameterTypes();
            String methodName = method.getName();
            Class[] targetParaTypes = new Class[extensionMethodParaTypes.length - 1];
            System.arraycopy(extensionMethodParaTypes, 1, targetParaTypes, 0, targetParaTypes.length);
            Long key = MethodKit.getMethodKey(targetClass, methodName, MethodKit.toBoxedType(targetParaTypes));
            methodCache.remove(key);
        }
    }

    private static Class<?>[] toBoxedType(Class<?>[] targetParaTypes) {
        int len = targetParaTypes.length;
        if (len == 0) {
            return targetParaTypes;
        }
        Class[] ret = new Class[len];
        for (int i = 0; i < len; ++i) {
            Class<?> temp = primitiveToBoxedMap.get(targetParaTypes[i]);
            ret[i] = temp != null ? temp : targetParaTypes[i];
        }
        return ret;
    }

    public static void removeExtensionMethod(Class<?> targetClass, Class<?> extensionClass) {
        MethodKit.removeExtensionMethod(targetClass, ReflectKit.newInstance(extensionClass));
    }

    private static String buildMethodSignatureForException(String preMsg, String methodName, Class<?>[] argTypes) {
        StringBuilder ret = new StringBuilder().append(preMsg).append(methodName).append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(argTypes[i] != null ? argTypes[i].getName() : "null");
            }
        }
        return ret.append(")").toString();
    }

    static {
        Class[] cs = new Class[]{System.class, Runtime.class, Thread.class, Class.class, ClassLoader.class, File.class, Compiler.class, InheritableThreadLocal.class, Package.class, Process.class, RuntimePermission.class, SecurityManager.class, ThreadGroup.class, ThreadLocal.class, Method.class, Proxy.class};
        for (Class c : cs) {
            forbiddenClasses.add(c);
        }
        String[] ms = new String[]{"getClass", "getDeclaringClass", "forName", "newInstance", "getClassLoader", "invoke", "notify", "notifyAll", "wait", "exit", "loadLibrary", "halt", "stop", "suspend", "resume"};
        for (String m : ms) {
            forbiddenMethods.add(m);
        }
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.class, Byte.TYPE);
        primitiveMap.put(Short.class, Short.TYPE);
        primitiveMap.put(Integer.class, Integer.TYPE);
        primitiveMap.put(Long.class, Long.TYPE);
        primitiveMap.put(Float.class, Float.TYPE);
        primitiveMap.put(Double.class, Double.TYPE);
        primitiveMap.put(Character.class, Character.TYPE);
        primitiveMap.put(Boolean.class, Boolean.TYPE);
        MethodKit.addExtensionMethod(String.class, new StringExt());
        MethodKit.addExtensionMethod(Integer.class, new IntegerExt());
        MethodKit.addExtensionMethod(Long.class, new LongExt());
        MethodKit.addExtensionMethod(Float.class, new FloatExt());
        MethodKit.addExtensionMethod(Double.class, new DoubleExt());
        MethodKit.addExtensionMethod(Short.class, new ShortExt());
        MethodKit.addExtensionMethod(Byte.class, new ByteExt());
        primitiveToBoxedMap = new HashMap(64);
        primitiveToBoxedMap.put(Byte.TYPE, Byte.class);
        primitiveToBoxedMap.put(Short.TYPE, Short.class);
        primitiveToBoxedMap.put(Integer.TYPE, Integer.class);
        primitiveToBoxedMap.put(Long.TYPE, Long.class);
        primitiveToBoxedMap.put(Float.TYPE, Float.class);
        primitiveToBoxedMap.put(Double.TYPE, Double.class);
        primitiveToBoxedMap.put(Character.TYPE, Character.class);
        primitiveToBoxedMap.put(Boolean.TYPE, Boolean.class);
    }
}

