/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import java.util.AbstractList;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class RangeArray
extends Expr {
    private Expr start;
    private Expr end;

    public RangeArray(Expr start, Expr end, Location location) {
        if (start == null) {
            throw new ParseException("The start value of range array can not be blank", location);
        }
        if (end == null) {
            throw new ParseException("The end value of range array can not be blank", location);
        }
        this.start = start;
        this.end = end;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object startValue = this.start.eval(scope);
        if (!(startValue instanceof Integer)) {
            throw new TemplateException("The start value of range array must be Integer", this.location);
        }
        Object endValue = this.end.eval(scope);
        if (!(endValue instanceof Integer)) {
            throw new TemplateException("The end value of range array must be Integer", this.location);
        }
        return new RangeList((Integer)startValue, (Integer)endValue, this.location);
    }

    public static class RangeList
    extends AbstractList<Integer> {
        final int start;
        final int size;
        final int increment;
        final Location location;

        public RangeList(int start, int end, Location location) {
            this.start = start;
            this.increment = start <= end ? 1 : -1;
            this.size = Math.abs(end - start) + 1;
            this.location = location;
        }

        @Override
        public Integer get(int index) {
            if (index < 0 || index >= this.size) {
                throw new TemplateException("Index out of bounds. Index: " + index + ", Size: " + this.size, this.location);
            }
            return this.start + index * this.increment;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

