/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.expr.ast;

import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.expr.ast.Method;
import org.tio.jfinal.template.expr.ast.MethodKit;
import org.tio.jfinal.template.expr.ast.SharedMethodKit;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class SharedMethod
extends Expr {
    private SharedMethodKit sharedMethodKit;
    private String methodName;
    private ExprList exprList;

    public SharedMethod(SharedMethodKit sharedMethodKit, String methodName, ExprList exprList, Location location) {
        if (MethodKit.isForbiddenMethod(methodName)) {
            throw new ParseException("Forbidden method: " + methodName, location);
        }
        this.sharedMethodKit = sharedMethodKit;
        this.methodName = methodName;
        this.exprList = exprList;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object[] argValues = this.exprList.evalExprList(scope);
        try {
            SharedMethodKit.SharedMethodInfo sharedMethodInfo = this.sharedMethodKit.getSharedMethodInfo(this.methodName, argValues);
            if (sharedMethodInfo != null) {
                return sharedMethodInfo.invoke(argValues);
            }
            throw new TemplateException(Method.buildMethodNotFoundSignature("Shared method not found: ", this.methodName, argValues), this.location);
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

