/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.ext.directive;

import java.io.IOException;
import java.util.Date;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class DateDirective
extends Directive {
    private Expr valueExpr;
    private Expr datePatternExpr;
    private int paraNum;

    @Override
    public void setExprList(ExprList exprList) {
        this.paraNum = exprList.length();
        if (this.paraNum > 2) {
            throw new ParseException("Wrong number parameter of #date directive, two parameters allowed at most", this.location);
        }
        if (this.paraNum == 0) {
            this.valueExpr = null;
            this.datePatternExpr = null;
        } else if (this.paraNum == 1) {
            this.valueExpr = exprList.getExpr(0);
            this.datePatternExpr = null;
        } else if (this.paraNum == 2) {
            this.valueExpr = exprList.getExpr(0);
            this.datePatternExpr = exprList.getExpr(1);
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (this.paraNum == 1) {
            this.outputWithoutDatePattern(env, scope, writer);
        } else if (this.paraNum == 2) {
            this.outputWithDatePattern(env, scope, writer);
        } else {
            this.outputToday(env, writer);
        }
    }

    private void outputToday(Env env, Writer writer) {
        this.write(writer, new Date(), env.getEngineConfig().getDatePattern());
    }

    private void outputWithoutDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value instanceof Date) {
            this.write(writer, (Date)value, env.getEngineConfig().getDatePattern());
        } else if (value != null) {
            throw new TemplateException("The first parameter date of #date directive must be Date type", this.location);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputWithDatePattern(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value instanceof Date) {
            Object datePattern = this.datePatternExpr.eval(scope);
            if (!(datePattern instanceof String)) throw new TemplateException("The sencond parameter datePattern of #date directive must be String", this.location);
            this.write(writer, (Date)value, (String)datePattern);
            return;
        } else {
            if (value == null) return;
            throw new TemplateException("The first parameter date of #date directive must be Date type", this.location);
        }
    }

    private void write(Writer writer, Date date, String datePattern) {
        try {
            writer.write(date, datePattern);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

