/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.ext.directive;

import java.io.IOException;
import java.util.Date;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class NowDirective
extends Directive {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() > 1) {
            throw new ParseException("#now directive support one parameter only", this.location);
        }
        super.setExprList(exprList);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String datePattern;
        if (this.exprList.length() == 0) {
            datePattern = env.getEngineConfig().getDatePattern();
        } else {
            Object dp = this.exprList.eval(scope);
            if (dp instanceof String) {
                datePattern = (String)dp;
            } else {
                throw new TemplateException("The parameter of #now directive must be String", this.location);
            }
        }
        try {
            writer.write(new Date(), datePattern);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

