/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.ext.directive;

import java.text.DecimalFormat;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class NumberDirective
extends Directive {
    private Expr valueExpr;
    private Expr patternExpr;

    @Override
    public void setExprList(ExprList exprList) {
        int paraNum = exprList.length();
        if (paraNum == 0) {
            throw new ParseException("The parameter of #number directive can not be blank", this.location);
        }
        if (paraNum > 2) {
            throw new ParseException("Wrong number parameter of #number directive, two parameters allowed at most", this.location);
        }
        this.valueExpr = exprList.getExpr(0);
        this.patternExpr = paraNum == 1 ? null : exprList.getExpr(1);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value == null) {
            return;
        }
        if (this.patternExpr == null) {
            this.outputWithoutPattern(writer, value);
        } else {
            this.outputWithPattern(scope, writer, value);
        }
    }

    private void outputWithoutPattern(Writer writer, Object value) {
        String ret = new DecimalFormat().format(value);
        this.write(writer, ret);
    }

    private void outputWithPattern(Scope scope, Writer writer, Object value) {
        Object pattern = this.patternExpr.eval(scope);
        if (!(pattern instanceof String)) {
            throw new TemplateException("The sencond parameter pattern of #number directive must be String", this.location);
        }
        String ret = new DecimalFormat((String)pattern).format(value);
        this.write(writer, ret);
    }
}

