/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.ext.directive;

import java.util.Map;
import org.tio.jfinal.kit.SyncWriteMap;
import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.EngineConfig;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Assign;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.source.ISource;
import org.tio.jfinal.template.stat.Ctrl;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Parser;
import org.tio.jfinal.template.stat.Scope;
import org.tio.jfinal.template.stat.ast.Define;
import org.tio.jfinal.template.stat.ast.Include;
import org.tio.jfinal.template.stat.ast.Stat;
import org.tio.jfinal.template.stat.ast.StatList;

public class RenderDirective
extends Directive {
    private String parentFileName;
    private Map<String, SubStat> subStatCache = new SyncWriteMap<String, SubStat>(16, 0.5f);

    @Override
    public void setExprList(ExprList exprList) {
        int len = exprList.length();
        if (len == 0) {
            throw new ParseException("The parameter of #render directive can not be blank", this.location);
        }
        if (len > 1) {
            for (int i = 1; i < len; ++i) {
                if (exprList.getExpr(i) instanceof Assign) continue;
                throw new ParseException("The " + (i + 1) + "th parameter of #render directive must be an assignment expression", this.location);
            }
        }
        this.parentFileName = this.location.getTemplateFile();
        this.exprList = exprList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalAssignExpressionAndGetFileName(Scope scope) {
        Ctrl ctrl = scope.getCtrl();
        try {
            ctrl.setLocalAssignment();
            Object object = this.exprList.evalExprList(scope)[0];
            return object;
        }
        finally {
            ctrl.setWisdomAssignment();
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object value = this.evalAssignExpressionAndGetFileName(scope = new Scope(scope));
        if (!(value instanceof String)) {
            throw new TemplateException("The parameter value of #render directive must be String", this.location);
        }
        String subFileName = Include.getSubFileName((String)value, this.parentFileName);
        SubStat subStat = this.subStatCache.get(subFileName);
        if (subStat == null) {
            subStat = this.parseSubStat(env, subFileName);
            this.subStatCache.put(subFileName, subStat);
        } else if (env.isDevMode() && (subStat.source.isModified() || subStat.env.isSourceListModified())) {
            subStat = this.parseSubStat(env, subFileName);
            this.subStatCache.put(subFileName, subStat);
        }
        subStat.exec(null, scope, writer);
        scope.getCtrl().setJumpNone();
    }

    private SubStat parseSubStat(Env env, String subFileName) {
        EngineConfig config = env.getEngineConfig();
        ISource subFileSource = config.getSourceFactory().getSource(config.getBaseTemplatePath(), subFileName, config.getEncoding());
        try {
            SubEnv subEnv = new SubEnv(env);
            StatList subStatList = new Parser(subEnv, subFileSource.getContent(), subFileName).parse();
            return new SubStat(subEnv, subStatList.getActualStat(), subFileSource);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), this.location, e);
        }
    }

    public static class SubEnv
    extends Env {
        public Env parentEnv;

        public SubEnv(Env parentEnv) {
            super(parentEnv.getEngineConfig());
            this.parentEnv = parentEnv;
        }

        @Override
        public Define getFunction(String functionName) {
            Define func = (Define)this.functionMap.get(functionName);
            return func != null ? func : this.parentEnv.getFunction(functionName);
        }
    }

    public static class SubStat
    extends Stat {
        public SubEnv env;
        public Stat stat;
        public ISource source;

        public SubStat(SubEnv env, Stat stat, ISource source) {
            this.env = env;
            this.stat = stat;
            this.source = source;
        }

        @Override
        public void exec(Env env, Scope scope, Writer writer) {
            this.stat.exec(this.env, scope, writer);
        }
    }
}

