/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.ext.directive;

import org.tio.jfinal.template.Directive;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.expr.ast.Const;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.expr.ast.Id;
import org.tio.jfinal.template.io.CharWriter;
import org.tio.jfinal.template.io.FastStringWriter;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;

public class StringDirective
extends Directive {
    private String name;
    private boolean isLocalAssignment = false;

    @Override
    public void setExprList(ExprList exprList) {
        Expr[] exprArray = exprList.getExprArray();
        if (exprArray.length == 0) {
            throw new ParseException("#string directive parameter cant not be null", this.location);
        }
        if (exprArray.length > 2) {
            throw new ParseException("wrong number of #string directive parameter, two parameters allowed at most", this.location);
        }
        if (!(exprArray[0] instanceof Id)) {
            throw new ParseException("#string first parameter must be identifier", this.location);
        }
        this.name = ((Id)exprArray[0]).getId();
        if (exprArray.length == 2 && exprArray[1] instanceof Const) {
            if (((Const)exprArray[1]).isBoolean()) {
                this.isLocalAssignment = ((Const)exprArray[1]).getBoolean();
            } else {
                throw new ParseException("#string sencond parameter must be boolean", this.location);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        CharWriter charWriter = new CharWriter(64);
        FastStringWriter fsw = new FastStringWriter();
        charWriter.init(fsw);
        try {
            this.stat.exec(env, scope, charWriter);
        }
        finally {
            charWriter.close();
        }
        if (this.isLocalAssignment) {
            scope.setLocal(this.name, fsw.toString());
        } else {
            scope.set(this.name, fsw.toString());
        }
    }

    @Override
    public boolean hasEnd() {
        return true;
    }
}

