/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.io;

import java.io.IOException;
import org.tio.jfinal.template.io.FloatingWriter;
import org.tio.jfinal.template.io.IWritable;
import org.tio.jfinal.template.io.IntegerWriter;
import org.tio.jfinal.template.io.LongWriter;
import org.tio.jfinal.template.io.Writer;

public class CharWriter
extends Writer {
    java.io.Writer out;
    char[] chars;
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();

    public CharWriter(int bufferSize) {
        this.chars = new char[bufferSize];
    }

    public CharWriter init(java.io.Writer writer) {
        this.out = writer;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out = null;
    }

    @Override
    public void write(String str, int offset, int len) throws IOException {
        while (len > 0) {
            int size = len > this.chars.length ? this.chars.length : len;
            str.getChars(offset, offset + size, this.chars, 0);
            this.out.write(this.chars, 0, size);
            offset += size;
            len -= size;
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(StringBuilder stringBuilder, int offset, int len) throws IOException {
        while (len > 0) {
            int size = len > this.chars.length ? this.chars.length : len;
            stringBuilder.getChars(offset, offset + size, this.chars, 0);
            this.out.write(this.chars, 0, size);
            offset += size;
            len -= size;
        }
    }

    @Override
    public void write(StringBuilder stringBuilder) throws IOException {
        this.write(stringBuilder, 0, stringBuilder.length());
    }

    @Override
    public void write(IWritable writable) throws IOException {
        char[] data = writable.getChars();
        this.out.write(data, 0, data.length);
    }

    @Override
    public void write(int intValue) throws IOException {
        IntegerWriter.write(this, intValue);
    }

    @Override
    public void write(long longValue) throws IOException {
        LongWriter.write(this, longValue);
    }

    @Override
    public void write(double doubleValue) throws IOException {
        FloatingWriter.write(this, doubleValue);
    }

    @Override
    public void write(float floatValue) throws IOException {
        FloatingWriter.write(this, floatValue);
    }

    @Override
    public void write(boolean booleanValue) throws IOException {
        this.out.write(booleanValue ? TRUE_CHARS : FALSE_CHARS);
    }
}

