/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.tio.jfinal.template.io.Encoder;

public class JdkEncoder
extends Encoder {
    private CharsetEncoder ce;

    public JdkEncoder(Charset charset) {
        this.ce = charset.newEncoder();
    }

    @Override
    public float maxBytesPerChar() {
        return this.ce.maxBytesPerChar();
    }

    @Override
    public int encode(char[] chars, int offset, int len, byte[] bytes) {
        this.ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = CharBuffer.wrap(chars, offset, len);
        try {
            CoderResult cr = this.ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
            return bb.position();
        }
        catch (CharacterCodingException x) {
            throw new RuntimeException("Encode error: " + x.getMessage(), x);
        }
    }
}

