/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.io;

import java.io.IOException;
import org.tio.jfinal.template.io.ByteWriter;
import org.tio.jfinal.template.io.CharWriter;
import org.tio.jfinal.template.io.IntegerWriter;

public class LongWriter {
    private static final byte[] minValueBytes = "-9223372036854775808".getBytes();
    private static final char[] minValueChars = "-9223372036854775808".toCharArray();

    public static void write(ByteWriter byteWriter, long value) throws IOException {
        if (value == Long.MIN_VALUE) {
            byteWriter.out.write(minValueBytes, 0, minValueBytes.length);
            return;
        }
        int size = value < 0L ? LongWriter.stringSize(-value) + 1 : LongWriter.stringSize(value);
        char[] chars = byteWriter.chars;
        byte[] bytes = byteWriter.bytes;
        LongWriter.getChars(value, size, chars);
        for (int j = 0; j < size; ++j) {
            bytes[j] = (byte)chars[j];
        }
        byteWriter.out.write(bytes, 0, size);
    }

    public static void write(CharWriter charWriter, long i) throws IOException {
        if (i == Long.MIN_VALUE) {
            charWriter.out.write(minValueChars, 0, minValueChars.length);
            return;
        }
        int size = i < 0L ? LongWriter.stringSize(-i) + 1 : LongWriter.stringSize(i);
        char[] chars = charWriter.chars;
        LongWriter.getChars(i, size, chars);
        charWriter.out.write(chars, 0, size);
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = IntegerWriter.DigitOnes[r];
            buf[--charPos] = IntegerWriter.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = IntegerWriter.DigitOnes[r];
            buf[--charPos] = IntegerWriter.DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = IntegerWriter.digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }
}

