/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.io;

import java.io.OutputStream;
import java.io.Writer;
import org.tio.jfinal.template.io.ByteWriter;
import org.tio.jfinal.template.io.CharWriter;
import org.tio.jfinal.template.io.EncoderFactory;
import org.tio.jfinal.template.io.FastStringWriter;

public class WriterBuffer {
    private static final int MIN_BUFFER_SIZE = 64;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private int bufferSize = 2048;
    private EncoderFactory encoderFactory = new EncoderFactory();
    private final ThreadLocal<ByteWriter> byteWriters = new ThreadLocal<ByteWriter>(){

        @Override
        protected ByteWriter initialValue() {
            return new ByteWriter(WriterBuffer.this.encoderFactory.getEncoder(), WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<CharWriter> charWriters = new ThreadLocal<CharWriter>(){

        @Override
        protected CharWriter initialValue() {
            return new CharWriter(WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<FastStringWriter> fastStringWriters = new ThreadLocal<FastStringWriter>(){

        @Override
        protected FastStringWriter initialValue() {
            return new FastStringWriter();
        }
    };

    public ByteWriter getByteWriter(OutputStream outputStream) {
        return this.byteWriters.get().init(outputStream);
    }

    public CharWriter getCharWriter(Writer writer) {
        return this.charWriters.get().init(writer);
    }

    public FastStringWriter getFastStringWriter() {
        return this.fastStringWriters.get();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 64 || bufferSize > 0x200000) {
            throw new IllegalArgumentException("bufferSize must between 63 and 2097153");
        }
        this.bufferSize = bufferSize;
    }

    public void setEncoderFactory(EncoderFactory encoderFactory) {
        if (encoderFactory == null) {
            throw new IllegalArgumentException("encoderFactory can not be null");
        }
        this.encoderFactory = encoderFactory;
    }

    public void setEncoding(String encoding) {
        this.encoderFactory.setEncoding(encoding);
    }
}

