/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat;

public class Compressor {
    protected char separator = (char)10;

    public Compressor() {
    }

    public Compressor(char separator) {
        if (separator > ' ') {
            throw new IllegalArgumentException("The parameter separator must be a separator character");
        }
        this.separator = separator;
    }

    public StringBuilder compress(StringBuilder content) {
        int len = content.length();
        if (len == 1) {
            return content;
        }
        int begin = 0;
        int forward = 0;
        int lineType = 1;
        StringBuilder result = null;
        while (forward < len) {
            if (content.charAt(forward) == '\n') {
                if (result == null) {
                    result = new StringBuilder(len);
                }
                this.compressLine(content, begin, forward - 1, lineType, result);
                forward = begin = forward + 1;
                lineType = 2;
                continue;
            }
            ++forward;
        }
        if (lineType == 1) {
            return content;
        }
        lineType = 3;
        this.compressLine(content, begin, forward - 1, lineType, result);
        return result;
    }

    protected void compressLine(StringBuilder content, int start, int end, int lineType, StringBuilder result) {
        if (lineType != 1) {
            while (start <= end && content.charAt(start) <= ' ') {
                ++start;
            }
        }
        if (lineType != 3) {
            while (end >= start && content.charAt(end) <= ' ') {
                --end;
            }
        }
        if (start <= end) {
            for (int i = start; i <= end; ++i) {
                result.append(content.charAt(i));
            }
            if (lineType != 3) {
                result.append(this.separator);
            }
        } else if (lineType == 1) {
            result.append(this.separator);
        }
    }
}

