/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat;

import org.tio.jfinal.template.stat.CharTable;
import org.tio.jfinal.template.stat.Symbol;
import org.tio.jfinal.template.stat.Token;

class TextToken
extends Token {
    private StringBuilder text;

    public TextToken(StringBuilder value, int row) {
        super(Symbol.TEXT, row);
        this.text = value;
    }

    public void append(StringBuilder content) {
        if (content != null) {
            this.text.append((CharSequence)content);
        }
    }

    public boolean deleteBlankTails() {
        for (int i = this.text.length() - 1; i >= 0; --i) {
            if (CharTable.isBlank(this.text.charAt(i))) continue;
            if (this.text.charAt(i) == '\n') {
                this.text.delete(i + 1, this.text.length());
                return true;
            }
            return false;
        }
        this.text.setLength(0);
        return true;
    }

    @Override
    public String value() {
        return this.text.toString();
    }

    public StringBuilder getContent() {
        return this.text;
    }

    @Override
    public String toString() {
        return this.text.toString();
    }

    @Override
    public void print() {
        System.out.print("[");
        System.out.print(this.row);
        System.out.print(", TEXT, ");
        System.out.print(this.text.toString());
        System.out.println("]");
    }
}

