/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat.ast;

import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;
import org.tio.jfinal.template.stat.ast.CaseSetter;
import org.tio.jfinal.template.stat.ast.Stat;
import org.tio.jfinal.template.stat.ast.StatList;

public class Case
extends Stat
implements CaseSetter {
    private Expr[] exprArray;
    private Stat stat;
    private Case nextCase;

    public Case(ExprList exprList, StatList statList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The parameter of #case directive can not be blank", location);
        }
        this.exprArray = exprList.getExprArray();
        this.stat = statList.getActualStat();
    }

    @Override
    public void setNextCase(Case nextCase) {
        this.nextCase = nextCase;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        throw new TemplateException("#case \u6307\u4ee4\u7684 exec \u4e0d\u80fd\u88ab\u8c03\u7528", this.location);
    }

    boolean execIfMatch(Object switchValue, Env env, Scope scope, Writer writer) {
        if (this.exprArray.length == 1) {
            Object value = this.exprArray[0].eval(scope);
            if (value == switchValue) {
                this.stat.exec(env, scope, writer);
                return true;
            }
            if (value != null && value.equals(switchValue)) {
                this.stat.exec(env, scope, writer);
                return true;
            }
        } else {
            for (Expr expr : this.exprArray) {
                Object value = expr.eval(scope);
                if (value == switchValue) {
                    this.stat.exec(env, scope, writer);
                    return true;
                }
                if (value == null || !value.equals(switchValue)) continue;
                this.stat.exec(env, scope, writer);
                return true;
            }
        }
        return this.nextCase != null ? this.nextCase.execIfMatch(switchValue, env, scope, writer) : false;
    }
}

