/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat.ast;

import java.util.Iterator;
import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ForCtrl;
import org.tio.jfinal.template.expr.ast.Logic;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Ctrl;
import org.tio.jfinal.template.stat.Scope;
import org.tio.jfinal.template.stat.ast.ForIteratorStatus;
import org.tio.jfinal.template.stat.ast.ForLoopStatus;
import org.tio.jfinal.template.stat.ast.Stat;
import org.tio.jfinal.template.stat.ast.StatList;

public class For
extends Stat {
    private ForCtrl forCtrl;
    private Stat stat;
    private Stat _else;

    public For(ForCtrl forCtrl, StatList statList, Stat _else) {
        this.forCtrl = forCtrl;
        this.stat = statList.getActualStat();
        this._else = _else;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        scope = new Scope(scope);
        if (this.forCtrl.isIterator()) {
            this.forIterator(env, scope, writer);
        } else {
            this.forLoop(env, scope, writer);
        }
    }

    private void forIterator(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        Object outer = scope.get("for");
        ctrl.setLocalAssignment();
        ForIteratorStatus forIteratorStatus = new ForIteratorStatus(outer, this.forCtrl.getExpr().eval(scope), this.location);
        ctrl.setWisdomAssignment();
        scope.setLocal("for", forIteratorStatus);
        Iterator<?> it = forIteratorStatus.getIterator();
        String itemName = this.forCtrl.getId();
        while (it.hasNext()) {
            scope.setLocal(itemName, it.next());
            this.stat.exec(env, scope, writer);
            forIteratorStatus.nextState();
            if (!ctrl.isJump()) continue;
            if (ctrl.isBreak()) {
                ctrl.setJumpNone();
                break;
            }
            if (ctrl.isContinue()) {
                ctrl.setJumpNone();
                continue;
            }
            return;
        }
        if (this._else != null && forIteratorStatus.getIndex() == 0) {
            this._else.exec(env, scope, writer);
        }
    }

    private void forLoop(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        Object outer = scope.get("for");
        ForLoopStatus forLoopStatus = new ForLoopStatus(outer);
        scope.setLocal("for", forLoopStatus);
        Expr init = this.forCtrl.getInit();
        Expr cond = this.forCtrl.getCond();
        Expr update = this.forCtrl.getUpdate();
        ctrl.setLocalAssignment();
        init.eval(scope);
        while (cond == null || Logic.isTrue(cond.eval(scope))) {
            ctrl.setWisdomAssignment();
            this.stat.exec(env, scope, writer);
            ctrl.setLocalAssignment();
            forLoopStatus.nextState();
            if (ctrl.isJump()) {
                if (ctrl.isBreak()) {
                    ctrl.setJumpNone();
                    break;
                }
                if (ctrl.isContinue()) {
                    ctrl.setJumpNone();
                } else {
                    ctrl.setWisdomAssignment();
                    return;
                }
            }
            update.eval(scope);
        }
        ctrl.setWisdomAssignment();
        if (this._else != null && forLoopStatus.getIndex() == 0) {
            this._else.exec(env, scope, writer);
        }
    }
}

