/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat.ast;

import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.expr.ast.Logic;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;
import org.tio.jfinal.template.stat.ast.Stat;
import org.tio.jfinal.template.stat.ast.StatList;

public class If
extends Stat {
    private Expr cond;
    private Stat stat;
    private Stat elseIfOrElse;

    public If(ExprList cond, StatList statList, Location location) {
        if (cond.length() == 0) {
            throw new ParseException("The condition expression of #if statement can not be blank", location);
        }
        this.cond = cond.getActualExpr();
        this.stat = statList.getActualStat();
    }

    @Override
    public void setStat(Stat elseIfOrElse) {
        this.elseIfOrElse = elseIfOrElse;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (Logic.isTrue(this.cond.eval(scope))) {
            this.stat.exec(env, scope, writer);
        } else if (this.elseIfOrElse != null) {
            this.elseIfOrElse.exec(env, scope, writer);
        }
    }
}

