/*
 * Decompiled with CFR 0.152.
 */
package org.tio.jfinal.template.stat.ast;

import org.tio.jfinal.template.Env;
import org.tio.jfinal.template.TemplateException;
import org.tio.jfinal.template.expr.ast.Expr;
import org.tio.jfinal.template.expr.ast.ExprList;
import org.tio.jfinal.template.io.Writer;
import org.tio.jfinal.template.stat.Location;
import org.tio.jfinal.template.stat.ParseException;
import org.tio.jfinal.template.stat.Scope;
import org.tio.jfinal.template.stat.ast.Stat;

public class Output
extends Stat {
    private Expr expr;

    public Output(ExprList exprList, Location location) {
        if (exprList.length() == 0) {
            throw new ParseException("The expression of output directive like #(expression) can not be blank", location);
        }
        this.expr = exprList.getActualExpr();
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            Object value = this.expr.eval(scope);
            if (value instanceof String) {
                String str = (String)value;
                writer.write(str, 0, str.length());
            } else if (value instanceof Number) {
                Class<?> c = value.getClass();
                if (c == Integer.class) {
                    writer.write((Integer)value);
                } else if (c == Long.class) {
                    writer.write((Long)value);
                } else if (c == Double.class) {
                    writer.write((Double)value);
                } else if (c == Float.class) {
                    writer.write(((Float)value).floatValue());
                } else if (c == Short.class) {
                    writer.write((Short)value);
                } else {
                    writer.write(value.toString());
                }
            } else if (value != null) {
                writer.write(value.toString());
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

