/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.util.HashSet;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientGroupStat;
import org.tio.client.ConnectionCompletionHandler;
import org.tio.client.DefaultClientAioListener;
import org.tio.client.ReconnConf;
import org.tio.client.intf.ClientAioHandler;
import org.tio.client.intf.ClientAioListener;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.ssl.SslConfig;
import org.tio.utils.lock.SetWithLock;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public class ClientTioConfig
extends TioConfig {
    private static final long serialVersionUID = 158156605759779013L;
    static Logger log = LoggerFactory.getLogger(ClientTioConfig.class);
    private ClientAioHandler clientAioHandler = null;
    private ClientAioListener clientAioListener = null;
    protected ReconnConf reconnConf;
    private ConnectionCompletionHandler connectionCompletionHandler = new ConnectionCompletionHandler();
    public final SetWithLock<ChannelContext> connecteds = new SetWithLock(new HashSet());
    public final SetWithLock<ChannelContext> closeds = new SetWithLock(new HashSet());

    public ClientTioConfig(ClientAioHandler aioHandler, ClientAioListener aioListener) {
        this(aioHandler, aioListener, null);
    }

    public ClientTioConfig(ClientAioHandler aioHandler, ClientAioListener aioListener, ReconnConf reconnConf) {
        this(aioHandler, aioListener, reconnConf, null, null);
    }

    public ClientTioConfig(ClientAioHandler aioHandler, ClientAioListener aioListener, ReconnConf reconnConf, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        super(tioExecutor, groupExecutor);
        this.groupStat = new ClientGroupStat();
        this.setClientAioHandler(aioHandler);
        this.setClientAioListener(aioListener);
        this.reconnConf = reconnConf;
    }

    public void useSsl() throws Exception {
        SslConfig sslConfig = SslConfig.forClient();
        this.setSslConfig(sslConfig);
    }

    @Override
    public AioHandler getAioHandler() {
        return this.getClientAioHandler();
    }

    @Override
    public AioListener getAioListener() {
        return this.getClientAioListener();
    }

    public ClientAioHandler getClientAioHandler() {
        return this.clientAioHandler;
    }

    public ClientAioListener getClientAioListener() {
        return this.clientAioListener;
    }

    public ConnectionCompletionHandler getConnectionCompletionHandler() {
        return this.connectionCompletionHandler;
    }

    public void setClientAioHandler(ClientAioHandler clientAioHandler) {
        this.clientAioHandler = clientAioHandler;
    }

    public void setClientAioListener(ClientAioListener clientAioListener) {
        this.clientAioListener = clientAioListener;
        if (this.clientAioListener == null) {
            this.clientAioListener = new DefaultClientAioListener();
        }
    }

    public void setConnectionCompletionHandler(ConnectionCompletionHandler connectionCompletionHandler) {
        this.connectionCompletionHandler = connectionCompletionHandler;
    }

    public void setReconnConf(ReconnConf reconnConf) {
        this.reconnConf = reconnConf;
    }

    public ReconnConf getReconnConf() {
        return this.reconnConf;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public String toString() {
        return "ClientTioConfig [name=" + this.name + "]";
    }
}

