/*
 * Decompiled with CFR 0.152.
 */
package org.tio.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientGroupStat;
import org.tio.client.ClientTioConfig;
import org.tio.client.ConnectionCompletionVo;
import org.tio.client.ReconnConf;
import org.tio.client.ReconnRunnable;
import org.tio.client.intf.ClientAioHandler;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.core.ssl.SslFacadeContext;
import org.tio.core.stat.ChannelStat;
import org.tio.utils.SystemTimer;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.lock.SetWithLock;

public class TioClient {
    private static Logger log = LoggerFactory.getLogger(TioClient.class);
    private AsynchronousChannelGroup channelGroup;
    private ClientTioConfig clientTioConfig;

    public TioClient(ClientTioConfig clientTioConfig) throws IOException {
        this.clientTioConfig = clientTioConfig;
        this.channelGroup = AsynchronousChannelGroup.withThreadPool(clientTioConfig.groupExecutor);
        this.startHeartbeatTask();
        this.startReconnTask();
    }

    public void asynConnect(Node serverNode) throws Exception {
        this.asynConnect(serverNode, null);
    }

    public void asynConnect(Node serverNode, Integer timeout) throws Exception {
        this.asynConnect(serverNode, null, null, timeout);
    }

    public void asynConnect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        this.connect(serverNode, bindIp, bindPort, null, timeout, false);
    }

    public ClientChannelContext connect(Node serverNode) throws Exception {
        return this.connect(serverNode, null);
    }

    public ClientChannelContext connect(Node serverNode, Integer timeout) throws Exception {
        return this.connect(serverNode, null, 0, timeout);
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, initClientChannelContext, timeout, true);
    }

    private ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, ClientChannelContext initClientChannelContext, Integer timeout, boolean isSyn) throws Exception {
        AsynchronousSocketChannel asynchronousSocketChannel = null;
        ClientChannelContext channelContext = null;
        boolean isReconnect = initClientChannelContext != null;
        long start = SystemTimer.currTime;
        asynchronousSocketChannel = AsynchronousSocketChannel.open(this.channelGroup);
        long end = SystemTimer.currTime;
        long iv = end - start;
        if (iv >= 100L) {
            log.error("{}, open \u8017\u65f6:{} ms", channelContext, (Object)iv);
        }
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
        InetSocketAddress bind = null;
        if (bindPort != null && bindPort > 0) {
            bind = false == StrUtil.isBlank((CharSequence)bindIp) ? new InetSocketAddress(bindIp, (int)bindPort) : new InetSocketAddress(bindPort);
        }
        if (bind != null) {
            asynchronousSocketChannel.bind(bind);
        }
        channelContext = initClientChannelContext;
        start = SystemTimer.currTime;
        InetSocketAddress inetSocketAddress = new InetSocketAddress(serverNode.getIp(), serverNode.getPort());
        ConnectionCompletionVo attachment = new ConnectionCompletionVo(channelContext, this, isReconnect, asynchronousSocketChannel, serverNode, bindIp, bindPort);
        if (isSyn) {
            Integer realTimeout = timeout;
            if (realTimeout == null) {
                realTimeout = 5;
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            attachment.setCountDownLatch(countDownLatch);
            asynchronousSocketChannel.connect(inetSocketAddress, attachment, this.clientTioConfig.getConnectionCompletionHandler());
            boolean f = countDownLatch.await(realTimeout.intValue(), TimeUnit.SECONDS);
            if (f) {
                return attachment.getChannelContext();
            }
            log.warn("countDownLatch.await() return false ");
            return attachment.getChannelContext();
        }
        asynchronousSocketChannel.connect(inetSocketAddress, attachment, this.clientTioConfig.getConnectionCompletionHandler());
        return null;
    }

    public ClientChannelContext connect(Node serverNode, String bindIp, Integer bindPort, Integer timeout) throws Exception {
        return this.connect(serverNode, bindIp, bindPort, null, timeout);
    }

    public AsynchronousChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public ClientTioConfig getClientTioConfig() {
        return this.clientTioConfig;
    }

    public void reconnect(ClientChannelContext channelContext, Integer timeout) throws Exception {
        this.connect(channelContext.getServerNode(), channelContext.getBindIp(), channelContext.getBindPort(), channelContext, timeout);
    }

    public void setClientTioConfig(ClientTioConfig clientTioConfig) {
        this.clientTioConfig = clientTioConfig;
    }

    private void startHeartbeatTask() {
        final ClientGroupStat clientGroupStat = (ClientGroupStat)this.clientTioConfig.groupStat;
        final ClientAioHandler aioHandler = this.clientTioConfig.getClientAioHandler();
        final String id = this.clientTioConfig.getId();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TioClient.this.clientTioConfig.isStopped()) {
                    if (((TioClient)TioClient.this).clientTioConfig.heartbeatTimeout <= 0L) {
                        log.warn("\u7528\u6237\u53d6\u6d88\u4e86\u6846\u67b6\u5c42\u9762\u7684\u5fc3\u8df3\u5b9a\u65f6\u53d1\u9001\u529f\u80fd\uff0c\u8bf7\u7528\u6237\u81ea\u5df1\u53bb\u5b8c\u6210\u5fc3\u8df3\u673a\u5236");
                        break;
                    }
                    SetWithLock<ChannelContext> setWithLock = ((TioClient)TioClient.this).clientTioConfig.connecteds;
                    ReentrantReadWriteLock.ReadLock readLock = setWithLock.readLock();
                    readLock.lock();
                    try {
                        Set set = (Set)setWithLock.getObj();
                        long currtime = SystemTimer.currTime;
                        for (ChannelContext entry : set) {
                            Packet packet;
                            ClientChannelContext channelContext = (ClientChannelContext)entry;
                            if (channelContext.isClosed || channelContext.isRemoved) continue;
                            ChannelStat stat = channelContext.stat;
                            long compareTime = Math.max(stat.latestTimeOfReceivedByte, stat.latestTimeOfSentByte);
                            long interval = currtime - compareTime;
                            if (interval < ((TioClient)TioClient.this).clientTioConfig.heartbeatTimeout / 2L || (packet = aioHandler.heartbeatPacket(channelContext)) == null) continue;
                            if (log.isInfoEnabled()) {
                                log.info("{}\u53d1\u9001\u5fc3\u8df3\u5305", (Object)channelContext.toString());
                            }
                            Tio.send(channelContext, packet);
                        }
                        if (!log.isInfoEnabled()) continue;
                        log.info("[{}]: curr:{}, closed:{}, received:({}p)({}b), handled:{}, sent:({}p)({}b)", new Object[]{id, set.size(), clientGroupStat.closed.get(), clientGroupStat.receivedPackets.get(), clientGroupStat.receivedBytes.get(), clientGroupStat.handledPackets.get(), clientGroupStat.sentPackets.get(), clientGroupStat.sentBytes.get()});
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    finally {
                        try {
                            readLock.unlock();
                            Thread.sleep(((TioClient)TioClient.this).clientTioConfig.heartbeatTimeout / 4L);
                        }
                        catch (Throwable e) {
                            log.error("", e);
                        }
                    }
                }
            }
        }, "tio-timer-heartbeat" + id).start();
    }

    private void startReconnTask() {
        final ReconnConf reconnConf = this.clientTioConfig.getReconnConf();
        if (reconnConf == null || reconnConf.getInterval() <= 0L) {
            return;
        }
        String id = this.clientTioConfig.getId();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!TioClient.this.clientTioConfig.isStopped()) {
                    long sleeptime;
                    log.info("closeds:{}, connections:{}", (Object)((TioClient)TioClient.this).clientTioConfig.closeds.size(), (Object)((TioClient)TioClient.this).clientTioConfig.connections.size());
                    LinkedBlockingQueue<ChannelContext> queue = reconnConf.getQueue();
                    ClientChannelContext channelContext = null;
                    try {
                        channelContext = (ClientChannelContext)queue.take();
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    if (channelContext == null || channelContext.isRemoved) continue;
                    SslFacadeContext sslFacadeContext = channelContext.sslFacadeContext;
                    if (sslFacadeContext != null) {
                        sslFacadeContext.setHandshakeCompleted(false);
                    }
                    if ((sleeptime = reconnConf.getInterval() - (SystemTimer.currTime - channelContext.stat.timeInReconnQueue)) > 0L) {
                        try {
                            Thread.sleep(sleeptime);
                        }
                        catch (InterruptedException e) {
                            log.error("", (Throwable)e);
                        }
                    }
                    if (channelContext.isRemoved || !channelContext.isClosed) continue;
                    ReconnRunnable runnable = channelContext.getReconnRunnable();
                    if (runnable == null) {
                        ClientChannelContext clientChannelContext = channelContext;
                        synchronized (clientChannelContext) {
                            runnable = channelContext.getReconnRunnable();
                            if (runnable == null) {
                                runnable = new ReconnRunnable(channelContext, TioClient.this, (Executor)reconnConf.getThreadPoolExecutor());
                                channelContext.setReconnRunnable(runnable);
                            }
                        }
                    }
                    runnable.execute();
                }
            }
        });
        thread.setName("tio-timer-reconnect-" + id);
        thread.setDaemon(true);
        thread.start();
    }

    public boolean stop() {
        boolean ret = true;
        try {
            this.clientTioConfig.groupExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        try {
            this.clientTioConfig.tioExecutor.shutdown();
        }
        catch (Exception e1) {
            log.error(e1.toString(), (Throwable)e1);
        }
        this.clientTioConfig.setStopped(true);
        try {
            ret = ret && this.clientTioConfig.groupExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
            ret = ret && this.clientTioConfig.tioExecutor.awaitTermination(6000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        log.info("client resource has released");
        return ret;
    }
}

