/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.common.BindType;
import org.tio.clu.common.bs.UpdateBsNodeReq;
import org.tio.utils.lock.SetWithLock;

public class BindedData {
    private static Logger log = LoggerFactory.getLogger(BindedData.class);
    private UpdateBsNodeReq lastUpdateBsNodeReq = null;
    public SetWithLock<String> uids = null;
    public SetWithLock<String> groups = null;
    public SetWithLock<String> tokens = null;
    public SetWithLock<String> bsids = null;
    public SetWithLock<String> ips = null;
    public SetWithLock<String> channelids = null;

    public void init() {
        this.uids = new SetWithLock(new HashSet());
        this.groups = new SetWithLock(new HashSet());
        this.tokens = new SetWithLock(new HashSet());
        this.bsids = new SetWithLock(new HashSet());
        this.ips = new SetWithLock(new HashSet());
        this.channelids = new SetWithLock(new HashSet());
    }

    public void clean() {
        this.uids = null;
        this.groups = null;
        this.tokens = null;
        this.bsids = null;
        this.ips = null;
        this.channelids = null;
        this.lastUpdateBsNodeReq = null;
    }

    public SetWithLock<String> getBindSet(BindType bindType) {
        switch (bindType) {
            case User: {
                return this.uids;
            }
            case Group: {
                return this.groups;
            }
            case Token: {
                return this.tokens;
            }
            case BsId: {
                return this.bsids;
            }
            case Ip: {
                return this.ips;
            }
            case ChannelId: {
                return this.channelids;
            }
        }
        log.error("can not find by BindType[{}]", (Object)bindType);
        return null;
    }

    public boolean contains(BindType bindType, String v) {
        SetWithLock<String> set = this.getBindSet(bindType);
        if (set == null) {
            return false;
        }
        return set.contains((Object)v);
    }

    public UpdateBsNodeReq getLastUpdateBsNodeReq() {
        return this.lastUpdateBsNodeReq;
    }

    public void setLastUpdateBsNodeReq(UpdateBsNodeReq lastUpdateBsNodeReq) {
        this.lastUpdateBsNodeReq = lastUpdateBsNodeReq;
    }

    public static void main(String[] args) {
    }
}

