/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.client.Cc;
import org.tio.clu.client.CluClientSessionContext;
import org.tio.clu.client.CluClientStarter;
import org.tio.clu.common.BindType;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.BestNodeReq;
import org.tio.clu.common.bs.BestNodeResp;
import org.tio.clu.common.bs.BindReq;
import org.tio.clu.common.bs.TransferReq;
import org.tio.clu.common.bs.UnbindReq;
import org.tio.clu.common.bs.UpdateBsNodeReq;
import org.tio.clu.common.utils.FstUtils;
import org.tio.clu.common.vo.BsPfmData;
import org.tio.clu.common.vo.PfmData;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.core.intf.PacketMeta;
import org.tio.core.utils.TioUtils;
import org.tio.server.ServerTioConfig;
import org.tio.utils.lock.MapWithLock;
import org.tio.utils.lock.ReadLockHandler;

public class CluClient {
    private static Logger log = LoggerFactory.getLogger(CluClient.class);
    public static boolean asBsservernode = Boolean.getBoolean("tio.clu.client.as.bsservernode");

    public static void main(String[] args) {
    }

    public static String getCgId(ClientChannelContext clientChannelContext) {
        return CluClient.getCluClientSessionContext(clientChannelContext).getCgId();
    }

    public static CluClientSessionContext getCluClientSessionContext(ChannelContext channelContext) {
        CluClientSessionContext cluClientSessionContext = (CluClientSessionContext)Clu.getCluSessionContext(channelContext);
        return cluClientSessionContext;
    }

    public static void initBindReq(ServerTioConfig bsServerTioConfig, ClientChannelContext clientChannelContext) {
        if (clientChannelContext == null) {
            return;
        }
        if (bsServerTioConfig == null) {
            return;
        }
        CluClient.initBindReq(BindType.User, clientChannelContext, bsServerTioConfig.users.getMap());
        CluClient.initBindReq(BindType.Group, clientChannelContext, bsServerTioConfig.groups.getGroupmap());
        CluClient.initBindReq(BindType.BsId, clientChannelContext, bsServerTioConfig.bsIds.getMap());
        CluClient.initBindReq(BindType.Token, clientChannelContext, bsServerTioConfig.tokens.getMap());
        CluClient.initBindReq(BindType.Ip, clientChannelContext, bsServerTioConfig.ips.getIpmap());
    }

    public static <T> void initBindReq(final BindType bindType, final ClientChannelContext clientChannelContext, MapWithLock<String, T> mapwithlock) {
        if (clientChannelContext == null) {
            return;
        }
        if (mapwithlock != null && mapwithlock.size() > 0) {
            mapwithlock.handle(new ReadLockHandler<Map<String, T>>(){

                public void handler(Map<String, T> t) {
                    Set<String> set = t.keySet();
                    String[] strarray = (String[])ArrayUtil.toArray(set, String.class);
                    CluClient.bindXxx(clientChannelContext, bindType, null, strarray);
                }
            });
        }
    }

    public static void bindXxx(ClientChannelContext clientChannelContext, BindType bindType, String v, String[] vs) {
        if (clientChannelContext == null) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)v) && ArrayUtil.isEmpty((Object[])vs)) {
            CluClientSessionContext cluClientSessionContext = CluClient.getCluClientSessionContext(clientChannelContext);
            if (cluClientSessionContext == null) {
                log.error("CluClientSessionContext is null");
                return;
            }
            if (Cc.getBindedData(clientChannelContext.getTioConfig()).contains(bindType, v)) {
                return;
            }
        }
        BindReq bindReq = new BindReq();
        bindReq.setBt(bindType.getValue());
        bindReq.setV(v);
        bindReq.setVs(vs);
        Clu.send(clientChannelContext, Command.BindReq, bindReq);
    }

    public static void bindXxx(ClientChannelContext clientChannelContext, BindType bindType, String v) {
        CluClient.bindXxx(clientChannelContext, bindType, v, null);
    }

    public static void bindXxx(TioConfig bsTioConfig, BindType bindType, String v, String[] vs) {
        if (bsTioConfig instanceof ServerTioConfig) {
            ServerTioConfig serverTioConfig = (ServerTioConfig)bsTioConfig;
            CluClient.bindXxx(Cc.next(serverTioConfig), bindType, v, vs);
        }
    }

    public static void bindXxx(TioConfig bsTioConfig, BindType bindType, String v) {
        CluClient.bindXxx(bsTioConfig, bindType, v, null);
    }

    public static void unbindXxx(ClientChannelContext clientChannelContext, BindType bindType, String v, String[] vs) {
        if (clientChannelContext == null) {
            return;
        }
        UnbindReq unbindReq = new UnbindReq();
        unbindReq.setBt(bindType.getValue());
        unbindReq.setV(v);
        unbindReq.setVs(vs);
        Clu.send(clientChannelContext, Command.UnbindReq, unbindReq);
    }

    public static void unbindXxx(ClientChannelContext clientChannelContext, BindType bindType, String v) {
        CluClient.unbindXxx(clientChannelContext, bindType, v, null);
    }

    public static void unbindXxx(TioConfig bsTioConfig, BindType bindType, String v, String[] vs) {
        if (bsTioConfig instanceof ServerTioConfig) {
            ServerTioConfig serverTioConfig = (ServerTioConfig)bsTioConfig;
            CluClient.unbindXxx(Cc.next(serverTioConfig), bindType, v, vs);
        }
    }

    public static void unbindXxx(TioConfig bsTioConfig, BindType bindType, String v) {
        CluClient.unbindXxx(bsTioConfig, bindType, v, null);
    }

    public static void transfer(ClientChannelContext clientChannelContext, BindType bindType, String v, String[] vs, Packet transferPacket) {
        if (clientChannelContext == null) {
            return;
        }
        if (BooleanUtil.isTrue((Boolean)transferPacket.isFromClu())) {
            return;
        }
        try {
            TransferReq transferReq = new TransferReq();
            transferReq.setBt(bindType.getValue());
            transferReq.setV(v);
            transferReq.setVs(vs);
            PacketMeta meta = transferPacket.getMeta();
            if (meta != null && meta.getCountDownLatch() != null) {
                transferPacket = transferPacket.clone();
                transferPacket.setMeta(null);
            }
            transferReq.setP(FstUtils.asByteArray(transferPacket));
            Clu.send(clientChannelContext, Command.TransferReq, transferReq);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public static void transfer(ClientChannelContext clientChannelContext, BindType bindType, String v, Packet transferPacket) {
        CluClient.transfer(clientChannelContext, bindType, v, null, transferPacket);
    }

    public static void transfer(TioConfig bsTioConfig, BindType bindType, String v, String[] vs, Packet transferPacket) {
        if (bsTioConfig instanceof ServerTioConfig) {
            ServerTioConfig serverTioConfig = (ServerTioConfig)bsTioConfig;
            CluClient.transfer(Cc.next(serverTioConfig), bindType, v, vs, transferPacket);
        }
    }

    public static void transfer(TioConfig bsTioConfig, BindType bindType, String v, Packet transferPacket) {
        CluClient.transfer(bsTioConfig, bindType, v, null, transferPacket);
    }

    public static void updateBsNode(ClientChannelContext clientChannelContext, ServerTioConfig bsServerTioConfig) {
        if (!asBsservernode) {
            return;
        }
        if (bsServerTioConfig == null) {
            return;
        }
        if (TioUtils.checkBeforeIO(clientChannelContext)) {
            Map<String, Node> clientAccessNodeMap = bsServerTioConfig.getClientAccessNodeMap();
            if (clientAccessNodeMap == null) {
                return;
            }
            PfmData pfm = new PfmData();
            pfm.setTcpCount(bsServerTioConfig.connections.size());
            BsPfmData bsNodeData = new BsPfmData(clientAccessNodeMap);
            bsNodeData.setCreateTime(bsServerTioConfig.startTime);
            bsNodeData.setPfm(pfm);
            UpdateBsNodeReq updateBsNodeReq = new UpdateBsNodeReq();
            updateBsNodeReq.setBsNodeData(bsNodeData);
            updateBsNodeReq.setType((byte)1);
            Clu.send(clientChannelContext, Command.UpdateBsNodeReq, updateBsNodeReq);
        }
    }

    public static BestNodeResp bestNodeReq(CluClientStarter cluClientStarter, Integer uid, String protocol, long timeout) {
        BestNodeReq bestNodeReq = new BestNodeReq();
        bestNodeReq.setUid(uid);
        bestNodeReq.setProtocol(protocol);
        ClientChannelContext clientChannelContext = Cc.next(cluClientStarter.getClientTioConfig());
        if (clientChannelContext == null) {
            return null;
        }
        CluPacket respPacket = Clu.synSend(clientChannelContext, Command.BestNodeReq, bestNodeReq, timeout);
        if (respPacket == null) {
            log.error("\u83b7\u53d6\u6700\u4f18\u670d\u52a1\u5668\uff0c\u54cd\u5e94\u8d85\u65f6");
            return null;
        }
        BestNodeResp bestNodeResp = Clu.getBodyObj(respPacket, BestNodeResp.class);
        return bestNodeResp;
    }

    public static BestNodeResp bestNodeReq(CluClientStarter cluClientStarter, Integer uid, String protocol) {
        return CluClient.bestNodeReq(cluClientStarter, uid, protocol, 5000L);
    }
}

