/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.intf.ClientAioHandler;
import org.tio.clu.client.PacketDispatcher;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.utils.ProtocolUtils;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;

public class CluClientAioHandler
implements ClientAioHandler {
    private static Logger log = LoggerFactory.getLogger(CluClientAioHandler.class);
    public static final CluPacket heartbeatPacket = new CluPacket(Command.HeartbeatReq);
    private PacketDispatcher packetDispatcher;
    private ServerTioConfig bsServerTioConfig;

    public CluClientAioHandler(PacketDispatcher packetDispatcher, ServerTioConfig bsServerTioConfig) {
        this.packetDispatcher = packetDispatcher;
        this.bsServerTioConfig = bsServerTioConfig;
    }

    @Override
    public CluPacket decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        return ProtocolUtils.decode(buffer, limit, position, readableLength, channelContext);
    }

    @Override
    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        return ProtocolUtils.encode(packet, tioConfig, channelContext);
    }

    @Override
    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        CluPacket cluPacket = (CluPacket)packet;
        this.packetDispatcher.dispatch(cluPacket, (ClientChannelContext)channelContext);
    }

    @Override
    public CluPacket heartbeatPacket(ChannelContext channelContext) {
        return heartbeatPacket;
    }

    public ServerTioConfig getBsServerTioConfig() {
        return this.bsServerTioConfig;
    }
}

