/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.intf.ClientAioListener;
import org.tio.clu.client.CluClient;
import org.tio.clu.client.CluClientSessionContext;
import org.tio.clu.client.CluClientStarter;
import org.tio.clu.common.Clu;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.HandshakeReq;
import org.tio.core.ChannelContext;
import org.tio.core.intf.Packet;
import org.tio.utils.crypto.Md5;

public class CluClientAioListener
implements ClientAioListener {
    private static Logger log = LoggerFactory.getLogger(CluClientAioListener.class);
    private CluClientStarter cluClientStarter = null;

    public static void main(String[] args) {
    }

    public CluClientAioListener(CluClientStarter cluClientStarter) {
        this.cluClientStarter = cluClientStarter;
    }

    @Override
    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect) {
        if (!isConnected) {
            return;
        }
        CluClientSessionContext cluSessionContext = new CluClientSessionContext();
        cluSessionContext.setCgId(this.cluClientStarter.getCgId());
        channelContext.setAttribute("tio.clu.session_key", cluSessionContext);
        ClientChannelContext clientChannelContext = (ClientChannelContext)channelContext;
        String token = channelContext.getId();
        int serverPort = clientChannelContext.getServerNode().getPort();
        String sign = Md5.getMD5((String)(token + System.getProperty("tio.clu.secret.key", "abcdefgh")));
        HandshakeReq handshakeReq = new HandshakeReq();
        handshakeReq.setToken(token);
        handshakeReq.setSign(sign);
        handshakeReq.setCgId(this.cluClientStarter.getCgId());
        Clu.send(clientChannelContext, Command.HandshakeReq, handshakeReq);
    }

    @Override
    public void onAfterDecoded(ChannelContext channelContext, Packet packet, int packetSize) {
    }

    @Override
    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess) {
    }

    @Override
    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) {
        CluClientSessionContext cluClientSessionContext = CluClient.getCluClientSessionContext(channelContext);
        if (cluClientSessionContext != null) {
            cluClientSessionContext.clean();
        }
    }

    @Override
    public void onAfterHandled(ChannelContext channelContext, Packet packet, long cost) throws Exception {
    }

    @Override
    public void onAfterReceivedBytes(ChannelContext channelContext, int receivedBytes) throws Exception {
    }
}

