/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.client.intf.ClientAioHandler;
import org.tio.client.intf.ClientAioListener;
import org.tio.clu.client.BindedData;
import org.tio.clu.client.Cc;
import org.tio.clu.client.CluClient;
import org.tio.clu.client.CluClientAioHandler;
import org.tio.clu.client.CluClientAioListener;
import org.tio.clu.client.PacketDispatcher;
import org.tio.clu.client.handler.ScanLocation;
import org.tio.clu.client.handler.msg.demo.DemoMessage;
import org.tio.clu.client.handler.msg.demo.DemoMessageListener;
import org.tio.clu.client.handler.rpc.demo.RpcDemoIntf;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.BestNodeReq;
import org.tio.clu.common.bs.BestNodeResp;
import org.tio.clu.common.bs.msg.Message;
import org.tio.clu.common.bs.msg.MsgApi;
import org.tio.clu.common.bs.msg.WrapMessageListener;
import org.tio.clu.common.bs.rpc.RpcApi;
import org.tio.core.Node;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;
import org.tio.utils.jfinal.P;

public class CluClientStarter {
    private static Logger log = LoggerFactory.getLogger(CluClientStarter.class);
    private ReconnConf reconnConf = null;
    private ClientAioHandler clientAioHandler = null;
    private ClientAioListener clientAioListener = null;
    private ClientTioConfig clientTioConfig = null;
    private TioClient tioClient = null;
    private Node cluServerNode = null;
    private ClientChannelContext[] clientChannelContexts = null;
    private ServerTioConfig bsServerTioConfig = null;
    private Class<? extends Packet> bsPacketClass = null;
    private String cgId = null;
    private BindedData bindedData = null;
    private static final String TIOCONFIG_NAME = "tio-clu-client";
    private Map<Class<? extends Message>, WrapMessageListener<? extends Message>> msgMap = null;
    long laststart = System.currentTimeMillis();

    public CluClientStarter(boolean useSsl, ServerTioConfig bsServerTioConfig, Node cluServerNode, Class<? extends Packet> bsPacketClass) throws Exception {
        this.bsServerTioConfig = bsServerTioConfig;
        this.bsPacketClass = bsPacketClass;
        this.reconnConf = new ReconnConf(P.getLong((String)"tio.clu.client.reconn.time", (Long)1000L));
        this.cluServerNode = cluServerNode;
        this.clientAioHandler = new CluClientAioHandler(new PacketDispatcher(new String[]{ScanLocation.class.getPackage().getName()}, bsServerTioConfig, bsPacketClass), bsServerTioConfig);
        this.clientAioListener = new CluClientAioListener(this);
        this.init(useSsl);
    }

    private void init(boolean useSsl) throws Exception {
        this.clientTioConfig = new ClientTioConfig(this.clientAioHandler, this.clientAioListener, this.reconnConf);
        this.clientTioConfig.setName(TIOCONFIG_NAME);
        this.clientTioConfig.setHeartbeatTimeout(120000L);
        if (useSsl) {
            this.clientTioConfig.useSsl();
        }
        this.tioClient = new TioClient(this.clientTioConfig);
        this.cgId = this.clientTioConfig.getTioUuid().uuid();
        this.bindedData = new BindedData();
        this.bindedData.init();
        this.clientTioConfig.set("tio.clu.client.binddata", this.bindedData);
        this.clientTioConfig.set("tio.clu.client.cluclientstarter", this);
    }

    public void start() throws Exception {
        this.clientChannelContexts = new ClientChannelContext[P.getInt((String)"tio.clu.client.connection.num", (Integer)10).intValue()];
        for (int i = 0; i < this.clientChannelContexts.length; ++i) {
            ClientChannelContext clientChannelContext;
            this.clientChannelContexts[i] = clientChannelContext = this.tioClient.connect(this.cluServerNode, 5);
        }
        this.startTimeTask();
        this.initMsg();
    }

    private void startTimeTask() {
        Thread cluClientTaskThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (CluClientStarter.this.bsServerTioConfig != null) {
                        ClientChannelContext clientChannelContext = Cc.next(CluClientStarter.this.clientChannelContexts);
                        if (clientChannelContext == null) {
                            log.error("\u6ca1\u6709\u53ef\u7528\u7684\u8fde\u63a5");
                        } else {
                            CluClient.updateBsNode(clientChannelContext, CluClientStarter.this.bsServerTioConfig);
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                        continue;
                    }
                    break;
                }
            }
        }, "clu-client-task-" + this.clientTioConfig.getId());
        cluClientTaskThread.setDaemon(true);
        cluClientTaskThread.setPriority(1);
        cluClientTaskThread.start();
    }

    private void initMsg() {
        MsgApi.addListener(this.getClientTioConfig(), DemoMessage.class, DemoMessageListener.me);
    }

    public void startTest() {
        this.testBestBsNode();
    }

    public void testRpc() {
        for (int i = 0; i < 30; ++i) {
            Thread cluClientTaskThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    AtomicInteger count = new AtomicInteger();
                    while (true) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e1) {
                            log.error(e1.toString(), (Throwable)e1);
                        }
                        DemoMessage demoMessage = new DemoMessage();
                        MsgApi.publish(CluClientStarter.this.clientTioConfig, demoMessage, true);
                        try {
                            RpcDemoIntf rpcDemo = RpcApi.getBean(RpcDemoIntf.class, CluClientStarter.this.clientTioConfig);
                            rpcDemo.sayStr("tan yao wu");
                            int c = count.incrementAndGet();
                            if (c % 1000 != 0) continue;
                            log.warn(c + "");
                            continue;
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }, "clu-client-task-test-" + this.clientTioConfig.getId() + "-" + i);
            cluClientTaskThread.setDaemon(true);
            cluClientTaskThread.setPriority(1);
            cluClientTaskThread.start();
        }
    }

    public void testBestBsNode() {
        final AtomicLong count = new AtomicLong();
        AtomicInteger useridseq = new AtomicInteger();
        final long starttime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Thread cluClientTaskThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    while (true) {
                        try {
                            while (true) {
                                long modbase;
                                BestNodeReq bestNodeReq = new BestNodeReq();
                                bestNodeReq.setUid(666);
                                bestNodeReq.setProtocol("ws");
                                CluPacket respPacket = Clu.synSend(Cc.next(CluClientStarter.this.clientTioConfig), Command.BestNodeReq, bestNodeReq);
                                if (respPacket == null) {
                                    log.error("\u83b7\u53d6\u6700\u4f18\u670d\u52a1\u5668\uff0c\u54cd\u5e94\u8d85\u65f6");
                                }
                                BestNodeResp bestNodeResp = Clu.getBodyObj(respPacket, BestNodeResp.class);
                                long c = count.incrementAndGet();
                                if (c % (modbase = 100000L) != 0L) continue;
                                long endtime = System.currentTimeMillis();
                                long iv = endtime - starttime;
                                double perSecond = 1000.0 * ((double)c / (double)iv);
                                long iv2 = endtime - CluClientStarter.this.laststart;
                                CluClientStarter.this.laststart = System.currentTimeMillis();
                                double perSecond2 = 1000.0 * ((double)modbase / (double)iv2);
                                System.out.println("\u9009\u62e9\u670d\u52a1\u5668\u54cd\u5e94\u6b21\u6570\uff1a" + c + ", \u603b\u6bcf\u79d2\u54cd\u5e94\uff1a" + perSecond + "\u6b21, \u672c\u9636\u6bb5\u6bcf\u79d2\u54cd\u5e94\uff1a" + perSecond2);
                            }
                        }
                        catch (Exception e) {
                            log.error("", (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
            }, "clu-client-task-test-" + this.clientTioConfig.getId() + "-" + i);
            cluClientTaskThread.setDaemon(true);
            cluClientTaskThread.setPriority(1);
            cluClientTaskThread.start();
        }
    }

    public TioClient getTioClient() {
        return this.tioClient;
    }

    public ClientTioConfig getClientTioConfig() {
        return this.clientTioConfig;
    }

    public static void main(String[] args) throws Exception {
    }

    public Node getCluServerNode() {
        return this.cluServerNode;
    }

    public ClientChannelContext[] getClientChannelContexts() {
        return this.clientChannelContexts;
    }

    public ServerTioConfig getBsServerTioConfig() {
        return this.bsServerTioConfig;
    }

    public Class<? extends Packet> getBsPacketClass() {
        return this.bsPacketClass;
    }

    public String getCgId() {
        return this.cgId;
    }

    public BindedData getBindedData() {
        return this.bindedData;
    }

    public Map<Class<? extends Message>, WrapMessageListener<? extends Message>> getMsgMap() {
        return this.msgMap;
    }

    public void setMsgMap(Map<Class<? extends Message>, WrapMessageListener<? extends Message>> msgMap) {
        this.msgMap = msgMap;
    }
}

