/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.client.handler.base.CluClientHandler;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.CommandHandler;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassScanHandler;
import org.tio.utils.hutool.ClassUtil;
import org.tio.utils.json.Json;

public class PacketDispatcher {
    private static Logger log = LoggerFactory.getLogger(PacketDispatcher.class);
    private static Map<Command, CluClientHandler> handlerMap = new HashMap<Command, CluClientHandler>();
    private ServerTioConfig bsServerTioConfig = null;
    private Class<? extends Packet> bsPacketClass = null;
    public Map<Command, Class<?>> pathClassMap = new TreeMap();

    public void dispatch(CluPacket cluPacket, ClientChannelContext clientChannelContext) throws Exception {
        Command command = cluPacket.getCommand();
        CluClientHandler handler = handlerMap.get((Object)command);
        if (handler != null) {
            log.info("{} \u6536\u5230\u6d88\u606f:{}", (Object)clientChannelContext, (Object)command);
            handler.handler(cluPacket, clientChannelContext, this.bsServerTioConfig, this.bsPacketClass);
            return;
        }
        log.warn("\u547d\u4ee4\u7801[{}]\u6ca1\u6709\u5bf9\u5e94\u7684\u5904\u7406\u7c7b", (Object)command);
    }

    public PacketDispatcher(String[] scanPackages, ServerTioConfig bsServerTioConfig, Class<? extends Packet> bsPacketClass) {
        this.bsServerTioConfig = bsServerTioConfig;
        this.bsPacketClass = bsPacketClass;
        if (scanPackages != null) {
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(CommandHandler.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            try {
                                Object bean = clazz.newInstance();
                                if (!(bean instanceof CluClientHandler)) {
                                    log.error("{}\u6ca1\u6709\u5b9e\u73b0 {}", (Object)clazz.getName(), (Object)CluClientHandler.class.getName());
                                    return;
                                }
                                CluClientHandler cluClientHandler = (CluClientHandler)bean;
                                CommandHandler mapping = clazz.getAnnotation(CommandHandler.class);
                                Command command = mapping.value();
                                Object obj = handlerMap.get((Object)command);
                                if (obj != null) {
                                    log.error("mapping[{}] already exists in class [{}]", (Object)command, (Object)obj.getClass().getName());
                                } else {
                                    handlerMap.put(command, cluClientHandler);
                                    PacketDispatcher.this.pathClassMap.put(command, clazz);
                                }
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            log.warn("command mapping\r\n{}", (Object)Json.toFormatedJson(this.pathClassMap));
        }
    }
}

