/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.client.bs.TransferListener;
import org.tio.clu.client.handler.base.AbsCluClientHandler;
import org.tio.clu.common.BindType;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.CommandHandler;
import org.tio.clu.common.bs.TransferNtf;
import org.tio.clu.common.utils.FstUtils;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;

@CommandHandler(value=Command.TransferNtf)
public class TransferNtfHandler
extends AbsCluClientHandler {
    private static Logger log = LoggerFactory.getLogger(TransferNtfHandler.class);

    @Override
    public void myHandler(CluPacket cluPacket, ClientChannelContext clientChannelContext, ServerTioConfig bsServerTioConfig, Class<? extends Packet> bsPacketClass) throws Exception {
        boolean con;
        if (bsServerTioConfig == null) {
            return;
        }
        TransferNtf transferNtf = Clu.getBodyObj(cluPacket, TransferNtf.class);
        Packet p = FstUtils.asObject(transferNtf.getP(), Packet.class);
        p.setFromClu(true);
        byte tt = transferNtf.getBt();
        BindType bindType = BindType.from(tt);
        TransferListener transferListener = bsServerTioConfig.getTransferListener();
        if (transferListener != null && !(con = transferListener.onBeforeTransfer(p, bindType, transferNtf))) {
            return;
        }
        String v = transferNtf.getV();
        String[] vs = transferNtf.getVs();
        switch (bindType) {
            case Group: {
                Tio.sendToGroup((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case User: {
                Tio.sendToUser((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case Token: {
                Tio.sendToToken((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case Ip: {
                Tio.sendToIp((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case BsId: {
                Tio.sendToBsId((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case ChannelId: {
                Tio.sendToId((TioConfig)bsServerTioConfig, v, vs, p, false);
                break;
            }
            case All: {
                Tio.sendToAll(bsServerTioConfig, p);
                break;
            }
            default: {
                log.error("can not find by BindType[{}]", (Object)bindType);
            }
        }
        if (transferListener != null) {
            transferListener.onAfterTransfer(p, bindType, transferNtf);
        }
    }
}

