/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client.handler.msg;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.client.handler.base.AbsCluClientHandler;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.CommandHandler;
import org.tio.clu.common.bs.msg.Message;
import org.tio.clu.common.bs.msg.MessageNtf;
import org.tio.clu.common.bs.msg.MsgApi;
import org.tio.clu.common.bs.msg.WrapMessageListener;
import org.tio.clu.common.utils.FstUtils;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;

@CommandHandler(value=Command.MessageNtf)
public class MessageNtfHandler
extends AbsCluClientHandler {
    private static Logger log = LoggerFactory.getLogger(MessageNtfHandler.class);

    @Override
    public void myHandler(CluPacket cluPacket, ClientChannelContext clientChannelContext, ServerTioConfig bsServerTioConfig, Class<? extends Packet> bsPacketClass) throws Exception {
        MessageNtf messageNtf = Clu.getBodyObj(cluPacket, MessageNtf.class);
        Message message = FstUtils.asObject(messageNtf.getM(), Message.class);
        WrapMessageListener<? extends Message> listener = MsgApi.getListener(clientChannelContext.getTioConfig(), message.getClass());
        if (listener == null) {
            log.warn("can not find MessageListener by {}", (Object)message.getClass().getName());
        } else {
            listener.onMessage(messageNtf.getFromCid(), message);
        }
    }
}

