/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.client.handler.rpc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.client.handler.base.AbsCluClientHandler;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.CommandHandler;
import org.tio.clu.common.bs.rpc.RpcInvokeReq;
import org.tio.clu.common.bs.rpc.RpcInvokeResp;
import org.tio.clu.common.bs.rpc.RpcUtils;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.server.ServerTioConfig;

@CommandHandler(value=Command.RpcInvokeReq)
public class RpcInvokeReqHandler
extends AbsCluClientHandler {
    private static Logger log = LoggerFactory.getLogger(RpcInvokeReqHandler.class);

    @Override
    public void myHandler(CluPacket cluPacket, ClientChannelContext clientChannelContext, ServerTioConfig bsServerTioConfig, Class<? extends Packet> bsPacketClass) throws Exception {
        RpcInvokeResp rpcResp;
        RpcInvokeReq rpcReq = Clu.getBodyObj(cluPacket, RpcInvokeReq.class);
        try {
            Object ret = RpcUtils.invoke(rpcReq);
            rpcResp = new RpcInvokeResp();
            rpcResp.setOk(true);
            rpcResp.setRetObject(ret);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            rpcResp = new RpcInvokeResp();
            rpcResp.setOk(false);
            rpcResp.setError(e);
        }
        rpcResp.setFromCgid(rpcReq.getFromCgid());
        CluPacket respPacket = CluPacket.from(Command.RpcInvokeResp, rpcResp);
        respPacket.setSynReqNo(cluPacket.getSynReqNo());
        Tio.send(clientChannelContext, respPacket);
    }
}

