/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common;

import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.CluSessionContext;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.base.Base;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.ReadLockHandler;
import org.tio.utils.lock.SetWithLock;

public class Clu {
    private static Logger log = LoggerFactory.getLogger(Clu.class);

    public static void sendToSet(final ChannelContext channelContext, SetWithLock<ChannelContext> setWithLock, final Base bodyObj, final Command command, final boolean skipSelf) {
        if (setWithLock != null) {
            setWithLock.handle((ReadLockHandler)new ReadLockHandler<Set<ChannelContext>>(){

                public void handler(Set<ChannelContext> set) {
                    for (ChannelContext channelContext1 : set) {
                        if (skipSelf && Objects.equals((Object)channelContext1, (Object)channelContext)) continue;
                        Clu.send(channelContext1, command, bodyObj);
                    }
                }
            });
        }
    }

    public static <T> T getBodyObj(CluPacket cluPacket, Class<T> clazz) {
        Object t = cluPacket.getBody();
        return (T)t;
    }

    public static void send(ChannelContext channelContext, Command command, Base bodyObj) {
        if (channelContext == null) {
            return;
        }
        CluPacket cluPacket = CluPacket.from(command, bodyObj);
        Tio.send(channelContext, cluPacket);
    }

    public static CluPacket synSend(ChannelContext channelContext, Command command, Base bodyObj, long timeout) {
        if (channelContext == null) {
            log.error("channelContext is null");
            return null;
        }
        CluPacket cluPacket = CluPacket.from(command, bodyObj);
        return Tio.synSend(channelContext, cluPacket, timeout);
    }

    public static CluPacket synSend(ChannelContext channelContext, Command command, Base bodyObj) {
        return Clu.synSend(channelContext, command, bodyObj, 5000L);
    }

    public static void synResp(ChannelContext channelContext, Command command, Base bodyObj, Packet reqPacket) {
        CluPacket cluPacket = CluPacket.from(command, bodyObj);
        cluPacket.setSynRespNo(reqPacket.getSynReqNo());
        Tio.send(channelContext, cluPacket);
    }

    public static CluSessionContext getCluSessionContext(ChannelContext channelContext) {
        CluSessionContext ret = (CluSessionContext)channelContext.getAttribute("tio.clu.session_key");
        return ret;
    }
}

