/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.BindReq;
import org.tio.clu.common.bs.base.Base;
import org.tio.core.intf.Packet;
import org.tio.utils.json.Json;

public class CluPacket
extends Packet {
    private static final long serialVersionUID = 2011243642394454841L;
    private static Logger log = LoggerFactory.getLogger(CluPacket.class);
    public static final byte HEARTBEAT_BYTE = -128;
    public static final byte HANDSHAKE_BYTE = -127;
    public static final byte VERSION = 1;
    private Object body;
    private Command command = null;

    public static CluPacket from(Command command, Base body) {
        CluPacket cluPacket = new CluPacket();
        cluPacket.setCommand(command);
        cluPacket.setBody(body);
        return cluPacket;
    }

    public String toString() {
        return "CluPacket [command=" + (Object)((Object)this.command) + "]";
    }

    public static void main(String[] args) {
        String str = String.format("%05d", (byte)1);
        System.out.println("" + str);
        BindReq bodyobj = new BindReq();
        bodyobj.setV("55555");
        bodyobj.setVs(new String[]{"3333", "9999"});
        CluPacket cluPacket = CluPacket.from(Command.BestNodeReq, bodyobj);
        CluPacket c1 = (CluPacket)cluPacket.clone();
        System.out.println(Json.toFormatedJson((Object)cluPacket));
        System.out.println(Json.toFormatedJson((Object)c1));
    }

    public CluPacket() {
    }

    public CluPacket(Command command) {
        this();
        this.setCommand(command);
    }

    public CluPacket(Command command, Object body) {
        this(command);
        this.body = body;
    }

    public Command getCommand() {
        return this.command;
    }

    @Override
    public String logstr() {
        if (this.command != null) {
            return "packet: command\u3010" + this.command.name() + "\u3011";
        }
        return null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Base body) {
        this.body = body;
    }
}

