/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.bs.msg;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.clu.client.Cc;
import org.tio.clu.client.CluClientStarter;
import org.tio.clu.common.Clu;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.msg.Message;
import org.tio.clu.common.bs.msg.MessageListener;
import org.tio.clu.common.bs.msg.MessageReq;
import org.tio.clu.common.bs.msg.WrapMessageListener;
import org.tio.clu.common.utils.FstUtils;

public class MsgApi {
    private static Logger log = LoggerFactory.getLogger(MsgApi.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<Class<? extends Message>, WrapMessageListener<? extends Message>> getMap(ClientTioConfig clientTioConfig) {
        CluClientStarter cluClientStarter = Cc.getCluClientStarter(clientTioConfig);
        Map<Class<? extends Message>, WrapMessageListener<? extends Message>> map = cluClientStarter.getMsgMap();
        if (map == null) {
            CluClientStarter cluClientStarter2 = cluClientStarter;
            synchronized (cluClientStarter2) {
                if (map == null) {
                    map = new HashMap<Class<? extends Message>, WrapMessageListener<? extends Message>>(10);
                    cluClientStarter.setMsgMap(map);
                }
            }
        }
        return map;
    }

    public static final WrapMessageListener<? extends Message> getListener(ClientTioConfig clientTioConfig, Class<?> clazz) {
        Map<Class<? extends Message>, WrapMessageListener<? extends Message>> map = MsgApi.getMap(clientTioConfig);
        return map.get(clazz);
    }

    public static void addListener(ClientTioConfig clientTioConfig, Class<? extends Message> clazz, MessageListener<? extends Message> messageListener) {
        Map<Class<? extends Message>, WrapMessageListener<? extends Message>> map = MsgApi.getMap(clientTioConfig);
        map.put(clazz, new WrapMessageListener<Message>(messageListener));
    }

    public static void publish(ClientTioConfig clientTioConfig, Message message, boolean sendToSelf) {
        CluClientStarter cluClientStarter = Cc.getCluClientStarter(clientTioConfig);
        MessageReq messageReq = new MessageReq();
        messageReq.setSendToSelf(sendToSelf);
        messageReq.setM(FstUtils.asByteArray(message));
        ClientChannelContext clientChannelContext = Cc.next(cluClientStarter.getClientChannelContexts());
        if (clientChannelContext == null) {
            log.error("\u6ca1\u6709\u53ef\u7528\u7684\u8fde\u63a5");
            return;
        }
        Clu.send(clientChannelContext, Command.MessageReq, messageReq);
    }

    public static void main(String[] args) {
    }
}

