/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.bs.rpc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientTioConfig;
import org.tio.clu.common.bs.rpc.RpcProxy;
import org.tio.clu.common.bs.rpc.RpcRegVo;
import org.tio.clu.common.bs.rpc.RpcService;
import org.tio.utils.hutool.ClassScanAnnotationHandler;
import org.tio.utils.hutool.ClassScanHandler;
import org.tio.utils.hutool.ClassUtil;

public class RpcApi {
    private static Logger log = LoggerFactory.getLogger(RpcApi.class);
    static final Map<String, Class<?>> CLASSNAME_CLAZZ_MAP = new HashMap();
    static final Map<Class<?>, MethodAccess> CLAZZ_METHODACCESS_MAP = new HashMap();
    static final Map<Class<?>, Object> CLAZZ_BEAN_MAP = new HashMap();

    public static void scan(String[] scanPackages, ClientTioConfig clientTioConfig) {
        if (scanPackages != null) {
            final HashSet<RpcRegVo> rpcRegVoList = new HashSet<RpcRegVo>(20);
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(RpcService.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            try {
                                Object bean = clazz.newInstance();
                                Object[] intfClassList = clazz.getInterfaces();
                                if (ArrayUtil.isNotEmpty((Object[])intfClassList)) {
                                    for (Object intfClass : intfClassList) {
                                        RpcRegVo rpcRegVo = new RpcRegVo();
                                        rpcRegVo.setIntfClazz((Class<?>)intfClass);
                                        rpcRegVo.setImplBean(bean);
                                        rpcRegVoList.add(rpcRegVo);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            RpcApi.register(clientTioConfig, rpcRegVoList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void register(ClientTioConfig clientTioConfig, Set<RpcRegVo> rpcRegVoList) {
        Iterator<RpcRegVo> iterator;
        if (CollUtil.isEmpty(rpcRegVoList)) {
            return;
        }
        HashSet<String> set = (HashSet<String>)clientTioConfig.get("tio.clu.client.rpcRegVoList");
        if (set == null) {
            iterator = "tio.clu.client.rpcRegVoList";
            // MONITORENTER : "tio.clu.client.rpcRegVoList"
            set = (Set)clientTioConfig.get("tio.clu.client.rpcRegVoList");
            if (set == null) {
                set = new HashSet<String>();
                clientTioConfig.set("tio.clu.client.rpcRegVoList", set);
            }
            // MONITOREXIT : iterator
        }
        for (RpcRegVo rpcRegVo : rpcRegVoList) {
            set.add(rpcRegVo.getIntfClazz().getName());
        }
        iterator = rpcRegVoList.iterator();
        while (iterator.hasNext()) {
            RpcRegVo rpcRegVo;
            rpcRegVo = iterator.next();
            CLASSNAME_CLAZZ_MAP.put(rpcRegVo.getIntfClazz().getName(), rpcRegVo.getIntfClazz());
            CLAZZ_METHODACCESS_MAP.put(rpcRegVo.getIntfClazz(), MethodAccess.get(rpcRegVo.getImplBean().getClass()));
            CLAZZ_BEAN_MAP.put(rpcRegVo.getIntfClazz(), rpcRegVo.getImplBean());
        }
    }

    public static <T> T getBean(Class<T> clazz, ClientTioConfig clientTioConfig) {
        return RpcProxy.getBean(clazz, clientTioConfig);
    }
}

