/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.bs.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.clu.client.Cc;
import org.tio.clu.client.CluClientStarter;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.rpc.RpcInvokeReq;
import org.tio.clu.common.bs.rpc.RpcInvokeResp;
import org.tio.utils.lock.LockUtils;

public class RpcProxy<T>
implements InvocationHandler {
    private static Logger log = LoggerFactory.getLogger(RpcProxy.class);
    private static final Map<Class<?>, RpcProxy<?>> CLAZZ_PROXY = new HashMap();
    private static final Map<Class<?>, Object> CLAZZ_BEAN = new HashMap();
    private Class<T> clazz;
    private ClientChannelContext[] clientChannelContexts;
    private CluClientStarter cluClientStarter;

    public RpcProxy(Class<T> clazz, CluClientStarter cluClientStarter) {
        this.clazz = clazz;
        this.cluClientStarter = cluClientStarter;
        this.clientChannelContexts = cluClientStarter.getClientChannelContexts();
        CLAZZ_PROXY.put(clazz, this);
        Object bean = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        CLAZZ_BEAN.put(clazz, bean);
    }

    public static <T> T getBean(Class<T> clazz, ClientTioConfig clientTioConfig) {
        Object bean = CLAZZ_BEAN.get(clazz);
        if (bean == null) {
            try {
                LockUtils.runWriteOrWaitRead((String)RpcProxy.class.getName(), RpcProxy.class, () -> {
                    Object bean1 = CLAZZ_BEAN.get(clazz);
                    if (bean1 == null) {
                        RpcProxy rpcProxy = new RpcProxy(clazz, Cc.getCluClientStarter(clientTioConfig));
                    }
                });
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            bean = CLAZZ_BEAN.get(clazz);
        }
        return (T)bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RpcInvokeReq rpcReq = new RpcInvokeReq();
        rpcReq.setClassName(this.clazz.getName());
        rpcReq.setMethodName(method.getName());
        rpcReq.setParamValues(args);
        rpcReq.setParamTypes(method.getParameterTypes());
        rpcReq.setFromCgid(this.cluClientStarter.getCgId());
        ClientChannelContext clientChannelContext = Cc.next(this.clientChannelContexts);
        if (clientChannelContext == null) {
            throw new Exception("\u6ca1\u6709\u53ef\u7528\u7684\u8fde\u63a5");
        }
        CluPacket respPacket = Clu.synSend(clientChannelContext, Command.RpcInvokeReq, rpcReq);
        if (respPacket == null) {
            throw new Exception("RPC\u54cd\u5e94\u8d85\u65f6");
        }
        RpcInvokeResp rpcResp = Clu.getBodyObj(respPacket, RpcInvokeResp.class);
        if (rpcResp.isOk()) {
            return rpcResp.getRetObject();
        }
        if (rpcResp.getError() != null) {
            throw rpcResp.getError();
        }
        throw new Exception(rpcResp.getMsg());
    }

    public static void main(String[] args) {
    }
}

