/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.bs.rpc;

import com.esotericsoftware.reflectasm.MethodAccess;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.clu.common.Clu;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.rpc.RpcApi;
import org.tio.clu.common.bs.rpc.RpcInvokeReq;
import org.tio.clu.common.bs.rpc.RpcRegisterReq;
import org.tio.clu.common.bs.rpc.RpcRegisterResp;

public class RpcUtils {
    private static Logger log = LoggerFactory.getLogger(RpcUtils.class);

    public static Object invoke(Class<?> intfClazz, String methodName, Class<?>[] paramTypes, Object[] paramValues) throws Exception {
        MethodAccess methodAccess = RpcApi.CLAZZ_METHODACCESS_MAP.get(intfClazz);
        Object obj = methodAccess.invoke(RpcApi.CLAZZ_BEAN_MAP.get(intfClazz), methodName, (Class[])paramTypes, paramValues);
        return obj;
    }

    public static Object invoke(RpcInvokeReq prcReq) throws Exception {
        return RpcUtils.invoke(RpcApi.CLASSNAME_CLAZZ_MAP.get(prcReq.getClassName()), prcReq.getMethodName(), prcReq.getParamTypes(), prcReq.getParamValues());
    }

    public static void registerToCluServer(Set<String> clazzNameList, ClientChannelContext clientChannelContext) {
        RpcRegisterReq rpcRegisterReq = new RpcRegisterReq();
        rpcRegisterReq.setClassNames(clazzNameList);
        CluPacket cluPacket = Clu.synSend(clientChannelContext, Command.RpcRegisterReq, rpcRegisterReq);
        if (cluPacket == null) {
            log.error("rpc\u6ce8\u518c\u5931\u8d25\uff0c\u54cd\u5e94\u8d85\u65f6");
        } else {
            RpcRegisterResp rpcRegisterResp = Clu.getBodyObj(cluPacket, RpcRegisterResp.class);
            if (rpcRegisterResp.isOk()) {
                log.info("\u6ce8\u518c\u6210\u529f");
            } else {
                log.error("rpc\u6ce8\u518c\u5931\u8d25\uff0c{}", (Object)rpcRegisterResp.getMsg());
            }
        }
    }
}

