/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.utils;

import java.io.IOException;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.SystemTimer;

public class FstUtils {
    private static Logger log = LoggerFactory.getLogger(FstUtils.class);
    private static final FSTConfiguration conf = FSTConfiguration.createDefaultConfiguration();

    public static Object asObject(byte[] bs) {
        return conf.asObject(bs);
    }

    public static <T> T asObject(byte[] bs, Class<T> clazz) {
        long start = SystemTimer.currTime;
        Object ret = null;
        try {
            ret = conf.asObject(bs);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        long end = SystemTimer.currTime;
        long iv = end - start;
        if (iv > 1000L) {
            log.warn("byte[]-->Object\u8017\u65f6{}ms, {}", (Object)iv, (Object)clazz.getName());
        }
        return (T)ret;
    }

    public static byte[] asByteArray(Object object) {
        long start = SystemTimer.currTime;
        byte[] ret = null;
        try {
            ret = conf.asByteArray(object);
            return ret;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            long end = SystemTimer.currTime;
            long iv = end - start;
            if (iv > 1000L) {
                log.warn("Object-->byte[]\u8017\u65f6{}ms", (Object)iv);
            }
            return ret;
        }
    }

    public static void main(String[] args) throws IOException {
    }
}

