/*
 * Decompiled with CFR 0.152.
 */
package org.tio.clu.common.utils;

import cn.hutool.core.util.ZipUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.clu.common.CluPacket;
import org.tio.clu.common.Command;
import org.tio.clu.common.bs.base.Base;
import org.tio.clu.common.utils.BufferUtil;
import org.tio.clu.common.utils.FstUtils;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.utils.SystemTimer;

public class ProtocolUtils {
    private static Logger log = LoggerFactory.getLogger(ProtocolUtils.class);
    public static final byte VERSION = 1;
    public static final int MAX_LENGTH_OF_BODY = 0x1400000;
    public static final int LEAST_HEADER_LENGTH = 5;
    public static final byte MASK_COMPRESS = 64;
    public static final byte MASK_SYN_REQ = 32;
    public static final byte MASK_SYN_RESP = 16;
    public static final byte MASK_4_BYTE_LENGTH = 8;
    public static final byte MASK_VERSION = 7;

    public static boolean decode4ByteLength(byte firstByte) {
        return (8 & firstByte) != 0;
    }

    public static boolean decodeCompress(byte firstByte) {
        return (0x40 & firstByte) != 0;
    }

    public static boolean decodeSynReq(byte firstByte) {
        return (0x20 & firstByte) != 0;
    }

    public static boolean decodeSynResp(byte firstByte) {
        return (0x10 & firstByte) != 0;
    }

    public static byte decodeVersion(byte version) {
        return (byte)(7 & version);
    }

    public static byte encode4ByteLength(byte bs, boolean is4ByteLength) {
        if (is4ByteLength) {
            return (byte)(bs | 8);
        }
        return (byte)(bs & 0x77);
    }

    public static byte encodeCompress(byte bs, boolean isCompress) {
        if (isCompress) {
            return (byte)(bs | 0x40);
        }
        return (byte)(bs & 0x3F);
    }

    public static byte encodeSynReq(byte bs, boolean synReq) {
        if (synReq) {
            return (byte)(bs | 0x20);
        }
        return (byte)(bs & 0x5F);
    }

    public static byte encodeSynResp(byte bs, boolean synResp) {
        if (synResp) {
            return (byte)(bs | 0x10);
        }
        return (byte)(bs & 0x6F);
    }

    public static int calcHeaderLen(boolean synReq, boolean synResp, boolean is4ByteLength) {
        return 5 + (synReq ? 4 : 0) + (synResp ? 4 : 0) + (is4ByteLength ? 2 : 0);
    }

    public static CluPacket decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        int bodyLength;
        boolean is4ByteLength;
        boolean synResp;
        byte firstbyte = BufferUtil.read(buffer);
        byte version = ProtocolUtils.decodeVersion(firstbyte);
        boolean isCompress = ProtocolUtils.decodeCompress(firstbyte);
        boolean synReq = ProtocolUtils.decodeSynReq(firstbyte);
        int headerLength = ProtocolUtils.calcHeaderLen(synReq, synResp = ProtocolUtils.decodeSynResp(firstbyte), is4ByteLength = ProtocolUtils.decode4ByteLength(firstbyte));
        if (readableLength < headerLength) {
            return null;
        }
        CluPacket cluPacket = new CluPacket();
        if (synReq) {
            int synReqNo = BufferUtil.readInt(buffer);
            cluPacket.setSynReqNo(synReqNo);
        }
        if (synResp) {
            int synRespNo = BufferUtil.readInt(buffer);
            cluPacket.setSynRespNo(synRespNo);
        }
        int n = bodyLength = is4ByteLength ? BufferUtil.readInt(buffer) : (int)BufferUtil.readShort(buffer);
        if (bodyLength > 0x1400000 || bodyLength < 0) {
            throw new TioDecodeException("bodyLength [" + bodyLength + "] is not right, remote:" + channelContext.getClientNode());
        }
        int neededLength = headerLength + bodyLength;
        if (readableLength < neededLength) {
            channelContext.setPacketNeededLength(neededLength);
            return null;
        }
        short commandValue = BufferUtil.readShort(buffer);
        Command command = Command.from(commandValue);
        if (command == null) {
            throw new TioDecodeException("\u6d88\u606f\u547d\u4ee4\u7801\u3010" + commandValue + "\u3011\u4e0d\u6b63\u786e");
        }
        cluPacket.setCommand(command);
        byte[] body = null;
        if (bodyLength > 0) {
            byte[] dst = new byte[bodyLength];
            buffer.get(dst);
            if (isCompress) {
                try {
                    byte[] unGzippedBytes = ZipUtil.unGzip((byte[])dst);
                    body = unGzippedBytes;
                }
                catch (Throwable e) {
                    log.error("{}, \u89e3\u538b\u5931\u8d25, bodyLength:{}, buffer:{}", new Object[]{channelContext, bodyLength, buffer});
                    throw new TioDecodeException(e);
                }
            } else {
                body = dst;
            }
            cluPacket.setBody(FstUtils.asObject(body, Base.class));
        }
        return cluPacket;
    }

    public static ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        CluPacket cluPacket = (CluPacket)packet;
        byte[] body = FstUtils.asByteArray(cluPacket.getBody());
        int bodyLen = 0;
        boolean isCompress = false;
        if (body != null && (bodyLen = body.length) > 4096) {
            try {
                long start = SystemTimer.currTime;
                byte[] gzipedbody = ZipUtil.gzip((byte[])body);
                long end = SystemTimer.currTime;
                long iv = end - start;
                if (iv > 1000L) {
                    log.warn("gzip\u538b\u7f29\u8017\u65f6{}ms", (Object)iv);
                }
                if (gzipedbody.length < body.length) {
                    log.info("\u538b\u7f29\u524d:{}, \u538b\u7f29\u540e:{}", (Object)body.length, (Object)gzipedbody.length);
                    body = gzipedbody;
                    bodyLen = gzipedbody.length;
                    isCompress = true;
                }
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        boolean synReq = cluPacket.getSynReqNo() != null;
        boolean synResp = cluPacket.getSynRespNo() != null;
        boolean is4ByteLength = false;
        if (bodyLen > Short.MAX_VALUE) {
            is4ByteLength = true;
        }
        int headerLength = ProtocolUtils.calcHeaderLen(synReq, synResp, is4ByteLength);
        int allLen = headerLength + bodyLen;
        ByteBuffer buffer = ByteBuffer.allocate(allLen);
        buffer.order(tioConfig.getByteOrder());
        byte firstbyte = ProtocolUtils.encodeCompress((byte)1, isCompress);
        firstbyte = ProtocolUtils.encodeSynReq(firstbyte, synReq);
        firstbyte = ProtocolUtils.encodeSynResp(firstbyte, synResp);
        firstbyte = ProtocolUtils.encode4ByteLength(firstbyte, is4ByteLength);
        buffer.put(firstbyte);
        if (synReq) {
            buffer.putInt(cluPacket.getSynReqNo());
        }
        if (synResp) {
            buffer.putInt(cluPacket.getSynRespNo());
        }
        if (is4ByteLength) {
            buffer.putInt(bodyLen);
        } else {
            buffer.putShort((short)bodyLen);
        }
        buffer.putShort(cluPacket.getCommand().getValue());
        if (body != null) {
            buffer.put(body);
        }
        return buffer;
    }
}

