/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.io.Serializable;
import java.util.Objects;
import org.tio.utils.hutool.StrUtil;

public class Node
implements Comparable<Node>,
Serializable {
    private static final long serialVersionUID = 1866316757333121660L;
    private String ip;
    private int port;
    private Byte ssl = 1;
    private String protocol = null;

    public Node() {
    }

    public Node(String ip, int port) {
        this();
        if (StrUtil.isBlank((CharSequence)ip)) {
            ip = "0.0.0.0";
        }
        this.setIp(ip);
        this.setPort(port);
    }

    public Node(String ip, int port, boolean useSsl) {
        this(ip, port);
        this.setSsl(useSsl ? (byte)1 : 0);
    }

    @Override
    public int compareTo(Node other) {
        if (other == null) {
            return -1;
        }
        if (Objects.equals(this.ip, other.getIp()) && Objects.equals(this.port, other.getPort())) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Node other = (Node)obj;
        return this.ip.equals(other.getIp()) && this.port == other.getPort();
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return (this.ip + ":" + this.port).hashCode();
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.ip).append(":").append(this.port);
        return builder.toString();
    }

    public Byte getSsl() {
        return this.ssl;
    }

    public void setSsl(Byte ssl) {
        this.ssl = ssl;
    }

    public static void main(String[] args) {
        String ip = "12.12.12.12";
        int port = 90;
        Node n1 = new Node(ip, port);
        Node n2 = new Node(ip, port);
        System.out.println(Objects.equals(n1, n2));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

